#include "mgP.h"
#include "mgribP.h"
#include "transform.h"
#include "mgribtoken.h"
#include <stdarg.h>

#define MAX 999999

/*-----------------------------------------------------------------------
 * Function:	mgrib_printmatrix
 * Description: prints rib binding for given matrix
 * Returns:	nothing
 * Author:	wisdom
 * Date:	Thu Mar 12 15:04:01 CST 1992	
 * Notes:
 */

void
mgrib_printmatrix(Transform T)
{
   int i;
   
   mrti(mr_concattransform, mr_parray, 16, T, mr_NULL);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_drawline, mgrib_drawPline, mgrib_drawCline, bounded
 * Description: draws a line for rman.
 * Returns:	nothing
 * Author:	wisdom, gunn, slevy, munzner
 * Date:	Tue Feb 18 14:20:29 CST 1992
 * Notes:
 */
 
void
mgrib_drawPline(HPoint3 *p1, HPoint3 *p2)
{
    Transform V;
    Transform P2S,O2S, O2P, P2O, S2O;
    int xsize, ysize;
    HPoint3 pnts[4], pnts2[4];
    HPoint3 s1, s2;
    int i;
    float dx,dy,k, len;

    /* This code will simulate line drawing in Photorman */
    /* create obj->proj transform */
    CamView(_mgc->cam, V);		/* world->proj */
    TmConcat(_mgc->xstk->T, V, O2P);	/* obj->proj */
    
    /* create obj->screen transform */
    WnGet(_mgc->win, WN_XSIZE, &xsize);
    WnGet(_mgc->win, WN_YSIZE, &ysize);
    TmScale(P2S, (float)xsize, (float)ysize, 1.0);
    TmConcat(O2P, P2S, O2S);
    
    /* translate & dehomogenize line endpoints from object to screen */
    HPt3TransPt3(O2S, p1, &s1);
    HPt3TransPt3(O2S, p2, &s2);

    dy = s2.y - s1.y;
    dx = s2.x - s1.x;
    len = hypot(dy,dx);
    k = _mgc->astk->ap.linewidth / len;
    
    pnts[0].x = s1.x -dy * k;
    pnts[0].y = s1.y +dx * k;
    pnts[1].x = s1.x +dy * k;
    pnts[1].y = s1.y -dx * k;
    pnts[2].x = s2.x +dy * k;
    pnts[2].y = s2.y -dx * k;
    pnts[3].x = s2.x -dy * k;
    pnts[3].y = s2.y +dx * k;
	    
    pnts[0].z = s1.z;
    pnts[1].z = s1.z;
    pnts[2].z = s2.z;
    pnts[3].z = s2.z;
    
    for (i=0; i<4; ++i) pnts[i].w = 1.0;
 	    
    /* now project back... */
    /* first, find S2O transform */
    TmInvert(O2S, S2O);
    
    /* now transform screen coords to object coords */
    
    /* DRAW HERE */
    mrti(mr_polygon, mr_P, mr_buildarray, 4*3, mr_NULL);
    for(i=0;i<4;i++) {
	HPoint3 pt;

	HPt3Transform(S2O, &pnts[i], &pt);
	HPt3Normalize(&pt, &pt);
	mrti(mr_subarray3, &pt, mr_NULL);
    }
}

void
mgrib_drawCline(HPoint3 *p1, HPoint3 *p2)
{
  Pt3Coord angle,length;
  Point3 t,xn,yn,axis;
  Point3 start, end;
  HPoint3 Hstart, Hend;
  static float unitz[3] = {0.0, 0.0, 1.0};
  float radius = .005;
  float size;
  int bounded(Point3 *p);
  
    HPt3Normalize(p1, &Hstart);
    HPt3Normalize(p2, &Hend);
    
    start.x = Hstart.x;
    start.y = Hstart.y;
    start.z = Hstart.z;
    
    end.x = Hend.x;
    end.y = Hend.y;
    end.z = Hend.z;
    
    if (! Pt3Equal(&start,&end)) {
	size = radius*_mgc->astk->ap.linewidth;
	Pt3Sub(&end,&start,&t);
	length = Pt3Length(&t);
	Pt3Cross(unitz,&t,&axis);
	Pt3Unit(&t);
	angle = Pt3Dot(unitz,&t);
	angle = acos(angle);
	mrti(mr_transformbegin, mr_NULL);
	if (bounded(&start))
	    mrti(mr_translate,
	    	mr_float, start.x,
		mr_float, start.y,
		mr_float, start.z, mr_NULL);
	if ( (t.x == 0.0) && (t.y == 0.0) && (t.z < 0.0)) {
	    /* if along negative z axis cross product is 0
	    but rotation by 180 degrees is necessary
	    (angle is computed correctly) */
	    axis.y = 1.0;
	}
	if (bounded(&axis))
	    mrti(mr_rotate, mr_float, DEGREES(angle),
	    	mr_float, axis.x, mr_float, axis.y, mr_float, axis.z, mr_NULL);
	if (length < MAX)
	    mrti(mr_cylinder, mr_float, size, mr_float, 0.,
	    	mr_float, length, mr_float, 360., mr_NULL);
	mrti(mr_transformend, mr_NULL);
    }
}

int 
bounded(p)
Point3 *p;
{
  if (! Pt3Equal(p,&Pt3Origin)) {
    if (p->x < MAX && p->y < MAX && p->z < MAX) 
      return 1;
  } else {
    return 0;
  }
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_drawpoint
 * Description: draws a point for rman.
 * Returns:	nothing
 * Author:	wisdom
 * Date:	Fri Mar 13 15:04:01 CST 1992	
 * Notes:
 */

void
mgrib_drawpoint(HPoint3 *p)
{
    float radius = 0.005;
    float size = radius*_mgc->astk->ap.linewidth;
    
    mrti(mr_sphere, mr_float, size, mr_float, size, mr_float, size,
	mr_float, 360., mr_NULL);
}
