
/* minnegraphics renderman token interface */
void mrti( int a1, ... );
void mrti_reset();

extern unsigned char tokenbuffer[];
extern unsigned char *ptr;

#define STRINGBASE	30     /* strings start at 30 */

enum tokentype {
    mr_NULL=0,

    /* RI Requests */
    mr_attributebegin,
    mr_attributeend,
    mr_transformbegin,
    mr_transformend,
    mr_identity,
    mr_concattransform, /* Transform T */
    mr_surface,
    mr_shadinginterpolation,
    mr_color,	    /* float *ptr (mr_array w/size=3) */
    mr_opacity,	    /* float alpha (will become an array) */
    mr_polygon,	    /* following arrays must be decalred explicitly */
    mr_patchmesh,   /* Ditto */
    mr_format,	    /* follow with mr_intseq */
    mr_projection,
    mr_clipping,
    mr_worldbegin,
    mr_worldend,
    mr_display,
    mr_screenwindow,
    mr_lightsource,
    mr_sphere,
    mr_translate,
    mr_rotate,
    mr_cylinder,

    /* Strings */
    mr_P=STRINGBASE,
    mr_N,
    mr_Cs,
    mr_Pw,
    mr_Os,
    mr_plastic,
    mr_hplastic,
    mr_eplastic,
    mr_heplastic,
    mr_constant,
    mr_ambientlight,
    mr_lightcolor,
    mr_distantlight,
    mr_intensity,
    mr_file,
    mr_rgb,
    mr_rgba,
    mr_Ka,
    mr_Kd,
    mr_Ks,
    mr_specularcolor,
    mr_roughness,
    mr_fov,
    mr_perspective,
    mr_to,
    
    mr_array,		/* (full array) size, f,f,.. */
    mr_buildarray,	/* size (subarys follow w/total subsizes==size) */
    mr_parray,  	/* subsize, *float, *float, .. */
    mr_subarray3,	/* ptr to aggregate of 3 floats (most common) */
    mr_section,		/* char *string */
    mr_comment,		/* char *string */
    mr_nl,		/* new line */

    mr_int,
    mr_intseq,		/* int numberOfInts, int, int, .. (NOT AN ARRAY!)*/
    mr_float,
    mr_string
};

struct _table {
    char *name;		 /* string representing token, or null */
    int  len;		 /* length of string */
    unsigned char reqn;  /* number used to define request/string to renderer */
    int  defined;	 /* flags weather request/string has been defined */
};

