#include "mgP.h"
#include "mgribP.h"
#include "mgribshade.h"
#include "mgribtoken.h"

mgrib_appearance( struct mgastk *astk, int mask )
{
    if(mask & APF_TRANSP) {
        /* presumably, we want this here as well as per vertex opacity
         * specification
         */
        float alpha = astk->mat.alpha;
	mrti(mr_opacity, mr_array, 3, alpha, alpha, alpha, mr_NULL);
    }

	
  /* WHAT ABOUT RENDERMAN?
   * No GL calls are needed for the following attributes because
   * they are always interpreted at draw-time:
   *            APF_FACEDRAW
   *            APF_EDGEDRAW
   *            APF_NORMSCALE
   *		APF_SHADING/APF_CONSTANT
   *		APF_SHADING/APF_SMOOTH
   *
   * Also, APF_EVERT is handled in mgri_material becuase renderman does
   * this in a shader
   */
	
}

void mgrib_lighting(struct mgastk *astk, int mask)
{
  LtLight *light;
  LmLighting *li = &astk->lighting;

  mrti(mr_section, "Interpreting Lights", mr_NULL);
  /* output the ambient light */
  mrti(mr_comment, "Ambient Light", mr_NULL);
  mrti(mr_lightsource, mr_ambientlight, mr_int, 0,
  	mr_lightcolor, mr_parray, 3, &(li->ambient), mr_NULL);

  /* lights are now defined after camera is defined */
  /* in mgri_worldbegin */
  /*mgri_lights( li->lights, astk );*/
}

void
mgrib_lights( LtLight *light, struct mgastk *astk )
{
  int i, lightsused;
  int baselight = -1;

  lightsused = 0;
  while (light) {
    if (light->private == 0) {
      /* this is a new light */
      if(baselight < 0) {
        register struct mgastk *a;
        for(a = astk, baselight = 1; a != NULL; a = a->next)
            baselight += MAXLIGHTS; /* Count appearance stack depth */
      }
      light->private = lightsused + baselight;
      light->changed = 1;  /* set changed, to force mgri_lightdef below */
    }

    if (light->position.w == 0.0) {
	/* directional light */
	mrti(mr_comment, "Directional Light",
		mr_lightsource, mr_distantlight, mr_int, light->private,
		mr_intensity, mr_float, light->intensity,
		mr_lightcolor, mr_parray, 3, &(light->color),
		mr_to, mr_array, 3,
		-light->position.x, -light->position.y, -light->position.z,
		mr_NULL);
    } else {
	/* point light */
	mrti(mr_lightsource, mr_string, "pointlight", mr_int, light->private,
	    mr_intensity, mr_float, light->intensity,
	    mr_lightcolor, mr_parray, 3, &(light->color),
	    mr_string, "from", mr_parray, 3, &(light->position),
	    mr_NULL);
    }

    ++lightsused;
    light = light->next;
  }
}
