#include "mgP.h"
#include "mgribP.h"
#include "mgribtoken.h"

#define	HAS_N	0x1
#define	HAS_C	0x2
#define	HAS_SMOOTH 0x4

#define VI_TUPLET_LIMIT 2 /* for sgi vi formatting (so we can use it!) */

int
mgrib_mesh( wrap, nu, nv, P, N, C)
    int wrap;
    int nu, nv;
    HPoint3 *P;
    Point3 *N;
    ColorA *C;
{
    register Appearance *ap;
    ColorA	*c;
    Color   *c3;
    Point3  *n;
    void    mgrib_submesh();
    void    mgrib_prmanmesh();
    int u,v;

    ap = &_mgc->astk->ap;

    if(ap->flag & APF_FACEDRAW) {
	mgrib_submesh( wrap, nu, nv, P, N, C);
    }
    
    if(ap->flag & APF_EDGEDRAW) {
	/* must draw edges manually */
	c3 = &ap->mat->edgecolor;
	mrti(mr_attributebegin, mr_color, mr_parray, 3, c3,
	    mr_opacity, mr_array, 3, 1., 1., 1.,
	    mr_surface, mr_constant, mr_NULL);
	mgrib_prmanmesh( wrap, nu, nv, P);
	mrti(mr_attributeend,mr_NULL);
    }
    
    if((ap->flag & APF_NORMALDRAW) && N!=NULL) {
	n = N;
	for(u=0; u<nu; u++)
	for(v=0; v<nv; v++)
	    mgrib_drawnormal(P[u + v * nv], n++);
    }
    
    return 1;
}

void
mgrib_submesh( wrap, nu, nv, P, N, C)
    int wrap;
    int nu, nv;
    HPoint3 *P;
    Point3 *N;
    ColorA *C;
{
    register Appearance *ap;
    char    *uwrap,*vwrap;
    int     shading;
    int     i;
    register HPoint3 *p;
    register Point3  *n;
    register ColorA	*c;
    int     nunv;
    int     viflag; /* used to insert \n into RIB file so lines */
		    /* won't be to long for 'vi' to work well   */
    float   alpha;

    nunv = nu * nv;
    p = P;
    n = N;
    c = C;
	    
    ap = &_mgc->astk->ap;
    
    if(wrap & MM_UWRAP) uwrap = "wrap";
    else uwrap = "nowrap";
    
    if(wrap & MM_VWRAP) vwrap = "wrap";
    else vwrap = "nowrap";
    
    mrti(mr_attributebegin, mr_NULL);

/* THIS SHOULD BE AT A HIGHER LEVEL
    mgrib_print("ShadingInterpolation ");
    if(ap->shading & APF_SMOOTH) mgrib_print("\"smooth\"\n");
    else mgrib_print("\"constant\"\n");
*/
    
    mrti(mr_patchmesh, mr_string, "bilinear",
    	mr_int, nu, mr_string, uwrap,
    	mr_int, nv, mr_string, vwrap,
	mr_P, mr_buildarray, 3*nunv, mr_NULL);
	
    for(i=0; i<nunv; i++, p++, viflag++) {
	mrti(mr_subarray3, p, mr_NULL);
	if(viflag>=VI_TUPLET_LIMIT) {
	    viflag=0;
	    /* wrap lines so they won't be too long for vi */
	    mrti(mr_nl, mr_NULL);
	}
    }
    
    /* use normals if supplied */
    if(N!=NULL) {
	viflag = 0;
	mrti(mr_N, mr_buildarray, 3*nunv, mr_NULL);
	for(i=0; i<nunv; i++, n++, viflag++) {
	    mrti(mr_subarray3, n, mr_NULL);
	    if(viflag>=VI_TUPLET_LIMIT) {
		viflag = 0;
		mrti(mr_nl, mr_NULL);
	    }
	}
    }
    
    /* use colors if supplied */
    if(C!=NULL) {
	viflag = 0;
	mrti(mr_Cs, mr_buildarray, 3*nunv, mr_NULL);
	for(i=0; i<nunv; i++, c++, viflag++) {
	    mrti(mr_subarray3, c, mr_NULL);
	    if(viflag>=VI_TUPLET_LIMIT) {
		viflag = 0;
		mrti(mr_nl, mr_NULL);
	    }
	}
	
	/* transperancy */
	if(ap->flag & APF_TRANSP) {
	    c = C;
	    mrti(mr_Os, mr_buildarray, 3*nunv, mr_NULL);
	    for(i=0; i<nunv; i++, c++) {
		mrti(mr_subarray3, c, mr_NULL);
		if(viflag>=VI_TUPLET_LIMIT)
		{
		    viflag = 0;
		    mrti(mr_nl, mr_NULL);
		}
	    }
	}			
		
    }

    mrti(mr_attributeend, mr_NULL);
}

void
mgrib_prmanmesh( wrap, nu, nv, P)
    int wrap;
    int nu, nv;
    HPoint3 *P;
{
    int u;
    int v;
    HPoint3 *p;
    HPoint3 *np;
    int nextu, nextv;
    
    for(u=0; u<nu; u++) {
    for(v=0; v<nv; v++) {
	p = &P[u + v * nv]; /* P[u][v] */
	nextu = u+1;
	if(nextu==nu) {
	    if(wrap & MM_UWRAP)
		np = &P[v * nv]; /* P[u=0][v] */
	    else
		np = NULL;
	}
	if(np!=NULL) mgrib_drawline(p,np);
    }
    }

    for(u=0; u<nu; u++) {
    for(v=0; v<nv; v++) {
	p = &P[u + v * nv]; /* P[u][v] */
	nextv = v+1;
	if(nextv==nv) {
	    if(wrap & MM_VWRAP)
		np = &P[u]; /* P[u][v=0] */
	    else
		np = NULL;
	}
	if(np!=NULL) mgrib_drawline(p,np);
    }
    }

}
