#include "mgP.h"
#include "mgribP.h"
#include "mgribtoken.h"
#include "polylistP.h"

void	mgrib_polygon( int nv, HPoint3 *v, int nn, Point3 *n,
	      	          int nc,ColorA *c );
void	mgrib_mesh( int wrap,int nu,int nv,HPoint3 *p, Point3 *n,ColorA *c );
void	mgrib_line( HPoint3 *p1, HPoint3 *p2 );
void	mgrib_polyline( int nv, HPoint3 *verts, int nc, ColorA *colors,
				int wrapped );
void	mgrib_polylist(  int np, Poly *p, int nv, Vertex *v, 
			     int plflags );
void	mgrib_drawnormal(HPoint3 *p, Point3 *n);
				 


/*-----------------------------------------------------------------------
 * Function:	mgrib_polygon
 * Description:	draw a polygon
 * Author:	wisdom
 * Date:	Fri Jan 10 13:57:53 CST 1992
 * Notes:	See mg.doc.
 *
 */
void
mgrib_polygon(int nv,  HPoint3 *V, 
	     int nn,  Point3 *N, 
	     int nc,  ColorA *C)
{
  register int i;	
  register HPoint3 *v;
  register Point3 *n;
  register Color *c;
  register ColorA *c4;
  HPoint3 hpt;
  int flag;
  int shading;
  int ninc;

    flag = _mgc->astk->ap.flag;
    shading = _mgc->astk->ap.shading;
    ninc = (nn > 1);
    
    mrti(mr_polygon,mr_NULL);
    
    /* Points */
    if(nv>0 && (flag & APF_FACEDRAW)) {
	mrti(mr_P,mr_buildarray, nv*3, mr_NULL);
	for(i = 0; i < nv; i++) {
	    /* we cannot descibe a polygon using Pw, so we normalize */
	    HPt3Normalize(&V[i], &hpt);
	    mrti(mr_subarray3, &hpt, mr_NULL);
	}
    }

    /* Supply Color (explicit) */
    if (nc>0 && (flag & APF_FACEDRAW) && !(flag & APF_CONSTANT)) {
	/* note:color should already be set in case of APF_CONSTANT,no?  */
	mrti(mr_Cs, mr_buildarray, nv*3, mr_NULL);
	for(i = 0; i < nv; i++) {
	    if(nc>1) c4 = &C[i]; else c4 = C;
	    mrti(mr_subarray3, (float *)c4, mr_NULL);
	}
    }

    /* Supply Transparency */
    if(flag & APF_TRANSP) {
	mrti(mr_Os, mr_buildarray, nv*3, mr_NULL);
	for(i = 0; i < nv; i++) {
	    float opacity[3];
	    if(nc>1) c4 = &C[i]; else c4 = C;
	    opacity[0]=opacity[1]=opacity[2]=c4->a;
	    mrti(mr_subarray3, opacity, mr_NULL);
	}
    }

    /* Supply Normals */
    if (nn>0 && (flag & APF_FACEDRAW) && !(flag & APF_CONSTANT)) {
	mrti(mr_N, mr_buildarray, nv*3, mr_NULL); 
	for(i = 0; i < nv; i++) {
	    if(nn>1) n = &N[i]; else n = N;
	    mrti(mr_subarray3, n, mr_NULL);
	}
    }
    
    /* Draw Edges */
    if(flag & APF_EDGEDRAW) {
	c = &_mgc->astk->ap.mat->edgecolor;
	mrti(mr_attributebegin,
	    mr_surface, mr_constant, 
	    mr_color, mr_parray, 3, c,
	    mr_opacity, mr_array, 3, 1., 1., 1., mr_NULL);
	
	for(i=0;i<nv-1;i++) mgrib_drawline(&V[i],&V[i+1]);
	mgrib_drawline(&V[i],&V[0]);
	mrti(mr_attributeend, mr_NULL);
    }
    
    /* Draw Normals */
    if(flag & APF_NORMALDRAW) {
    for (n = N, v = V, i = 0; i<nv; ++i, ++v, n += ninc)
	mgrib_drawnormal(v, n);
    }
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_line
 * Description:	draws a line
 * Author:	wisdom
 * Date:	Fri Jan 17 14:31:06 CST 1992
 * Notes:	see mg.doc
 */
void mgrib_line( HPoint3 *p1, HPoint3 *p2 )
{
    mrti(mr_attributebegin, mr_surface, mr_constant, mr_NULL);
    mgrib_drawline(p1,p2);
    mrti(mr_attributeend, mr_NULL);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_polyline
 * Description:	draws a Polyline
 * Author:	wisdom
 * Date:	Fri Jan 17 14:31:06 CST 1992
 * Notes:	see mg.doc
 */
void mgrib_polyline( int nv, HPoint3 *v, int nc, ColorA *c, int wrapped )
{
	ColorA *color;
	
	mrti(mr_attributebegin, mr_surface, mr_constant, mr_NULL);
	if(nc==0) mrti(mr_color, mr_parray, 3,
	    &_mgc->astk->mat.edgecolor, mr_NULL);
	if(nc==1) mrti(mr_color, mr_parray, 3, c, mr_NULL);
	if(nv == 1) {
		mgrib_drawpoint(v);
	}
	else {
	    if(wrapped) {
		if(nc > 1) {
		    color = c + nc - 1;
		    mrti(mr_color, mr_parray, 3, color, mr_NULL);
		}
		mgrib_drawline(v + nv - 1,v);
	    }
    
	    while(--nv > 0) {
		if(nc > 1) {
		    color = c++;
		    mrti(mr_color, mr_parray, 3, color, mr_NULL);
		}
		mgrib_drawline(v,(v+1));
		v++;
	    }
	}
	
	mrti(mr_attributeend, mr_NULL);

}


/*-----------------------------------------------------------------------
 * Function:	mgrib_polylist
 * Description:	draws a Polylist: linked list of Polys
 * Author:	wisdom
 * Date:	Wed Jan 22 16:07:03 CST 1992
 * Notes:	see mg.doc
 */
void mgrib_polylist( int np, Poly *P, int nv, Vertex *V, int plflags )
{
  register int i,j;
  register Poly *p;
  register Vertex **v, *vp;
  register Point3 *n;
  HPoint3 hpt;
  int flag,shading;
  Color *color;
  ColorA *colorA;


    flag = _mgc->astk->ap.flag;
    shading = _mgc->astk->ap.shading;

    if (shading & APF_CONSTANT) plflags &= ~(PL_HASVN|PL_HASPN);
    else if (shading & APF_FLAT) plflags &= ~PL_HASVN;
    else if (shading & APF_SMOOTH) plflags &= ~PL_HASPN;


    if (flag & APF_FACEDRAW) {
	mrti(mr_attributebegin, mr_NULL);
	for (p = P, i = 0; i < np; i++, p++) {

	    /* per polygon color */
	    if (plflags & PL_HASPCOL) {
		mrti(mr_color, mr_parray, 3, &p->pcol, mr_NULL);
	    }
	    
	    mrti(mr_polygon, mr_NULL);

	    /* do points */
	    mrti(mr_P, mr_buildarray, p->n_vertices*3, mr_NULL);
	    for (j=0, v=p->v; j < p->n_vertices; j++, v++) {
		HPt3Normalize(&(*v)->pt, &hpt);
		mrti(mr_subarray3, &hpt, mr_NULL);
	    }
			    
	    /* colors, if supplied */
	    if(plflags & PL_HASVCOL) {
		mrti(mr_Cs, mr_buildarray, p->n_vertices*3, mr_NULL);
		for (j=0, v=p->v; j < p->n_vertices; j++, v++) {
		    mrti(mr_subarray3, &(*v)->vcol);
		}
	    }
	    
	    /* then transparency, if defined */
	    if(flag & APF_TRANSP) {
		mrti(mr_Os, mr_buildarray, p->n_vertices*3, mr_NULL);
		for (j=0, v=p->v; j < p->n_vertices; j++, v++) {
		    float opacity[3];
		    opacity[0]=opacity[1]=opacity[2]=(*v)->vcol.a;
		    mrti(mr_subarray3, opacity, mr_NULL);
		}
	    }

	    /* now normals, if supplied */
	    if(plflags & PL_HASVN) {
		mrti(mr_N, mr_buildarray, p->n_vertices*3, mr_NULL);
		for (j=0, v=p->v; j < p->n_vertices; j++, v++) {
		    mrti(mr_subarray3, &((*v)->vn), mr_NULL);
		}
	    } else if(plflags & PL_HASPN) {
	    	mrti(mr_N, mr_buildarray, p->n_vertices*3, mr_NULL);
		for(j=0, v=p->v; j< p->n_vertices; j++, v++) {
		    mrti(mr_subarray3, &(p->pn), mr_NULL);
		}
            }
	}
    mrti(mr_attributeend, mr_NULL);
    }


    if (flag & APF_EDGEDRAW) {
	color = &_mgc->astk->ap.mat->edgecolor;
	mrti(mr_attributebegin, mr_surface, mr_constant,
		mr_color, mr_parray, 3, color,
		mr_opacity, mr_array, 3, 1., 1., 1., mr_NULL);
	
	for (p = P, i = 0; i < np; i++, p++) {	
	    for (j=0, v=p->v; j < (p->n_vertices-1); j++, v++) {
		mgrib_drawline((HPoint3 *)*v,(HPoint3*)*(v+1));
	    }
	    mgrib_drawline((HPoint3 *)*v,(HPoint3 *)*(p->v));
	}
	mrti(mr_attributeend,mr_NULL);
    }


    if (flag & APF_NORMALDRAW) {
	/* since mg_drawnormal handles attributes and stacking, we do nothing here */
	if (plflags & PL_HASPN) {
	    for (p = P, i = 0; i < np; i++, p++) {
		for (j=0, v=p->v; j < p->n_vertices; j++, v++) {
		    mgrib_drawnormal(&(*v)->pt, &p->pn);
		}
	    }
	} else if (plflags & PL_HASVN) {
	    for (vp = V, i = 0; i < nv; i++, vp++) {
		mgrib_drawnormal(&vp->pt, &vp->vn);
	    }
	}
    }
    
}

/* There is a basic problem now with 4-d points and 3-d normal vectors.
For now, we'll just ignore the 4-th coordinate of the point when 
computing the tip of the normal vector.  This will work OK with all
existing models, but for genuine 4-d points it won't work.  But,
come to think of it, what is the correct interpretation of the
normal vector when the points live in 4-d?
*/
void
mgrib_drawnormal(HPoint3 *p, Point3 *n) {	
    HPoint3 scaledn,end, tp;
    float scale;
    Color *color;
    
    scale = _mgc->astk->ap.nscale;
    if (p->w < 0.0) return;
    HPt3Normalize(p, &tp);
    Pt3Mul(scale, n, &scaledn);
    scaledn.w = 0.0;
    HPt3Add(&tp, &scaledn, &end);
    
    color = &_mgc->astk->mat.normalcolor;
    mrti(mr_attributebegin, mr_surface, mr_constant,
	 mr_color, mr_parray, 3, color,
	 mr_opacity, mr_array, 3, 1., 1., 1., mr_NULL);
    mgrib_drawline(&tp,&end);
    mrti(mr_attributeend, mr_NULL);
    
}
