#include <stdio.h>
#include "mg.h"
#include "mgP.h"
#include "mgrib.h"
#include "transform.h"

typedef struct mgribcontext {
  struct mgcontext mgctx;	/* The mgcontext */
  int born;			/* Has window been displayed on the screen? */
  int win;			/* GL window ID, or 0 */
  int geomtype;			/* geom type:MG_EUCLIDEAN or MG_HYPERBOLIC */
  Transform W2C;		/* current W2C xform */
  Transform C2W;		/* current C2W xform */
  Transform W2S;		/* camera-to-screen xform */
  Transform O2S;		/* current object-to-screen xform */

  
  int render_device;	/* Device Options */
#define RMD_ASCII	0x1
#define RMD_BINARY	0x2


/* Which line drawing technique?
 * MG_RIPOLYGON for creating RIB tokens true to OOGL/geomview, but may appear
 *    incorrect when viewed dynamically
 * MG_RICYLINDER for creating RIB tokens which may be dynamically viewed, but
 *    may not be true to OOGL/geomview
 * MG_RIPRMANLINE for NeXT Renderer - May Cause Incompatibilities!
 * Note: Future versions of renderman should support line drawing, NeXT does
 * now.
 */
  int line_mode;

  FILE *rib;
  char filepath[256];
#define DEFAULT_RIB_FILE "geom.rib"
  
} mgribcontext;

/* Make some convenient defines */
#define RiDEV  _mgric->render_device
#define NotImplemented(name) fprintf(stderr,"%s is not yet implemented.\n",name);

#define _mgribc		((mgribcontext*)_mgc)

void mgrib_printmatrix(Transform T);
void mgrib_drawline(HPoint3 *p1, HPoint3 *p2);
void mgrib_drawpoint(HPoint3 *p);
void mgrib_flushbuffer();
