#include "mg.h"
#include "mgP.h"
#include "mgribP.h"
#include "mgribshade.h"
#include "mgribtoken.h"
#include <stdio.h>
#include <sys/types.h>

mgcontext * mgrib_ctxcreate(int a1, ...);
void	    mgrib_ctxset( int a1, ...  );
int	    mgrib_feature( int feature );
void	    mgrib_ctxdelete( mgcontext *ctx );
int	    mgrib_ctxget( int attr, void* valueptr );
int	    mgrib_ctxselect( mgcontext *ctx );
void	    mgrib_sync( void );
void	    mgrib_worldbegin( void );
void	    mgrib_worldend( void );
void	    mgrib_reshapeviewport( void );
void	    mgrib_identity( void );
void	    mgrib_transform( Transform T );
int	    mgrib_pushtransform( void );
int	    mgrib_poptransform( void );
void	    mgrib_gettransform( Transform T );
void	    mgrib_settransform( Transform T );
void	    mgrib_material( struct mgastk *mastk, int merge );
int	    mgrib_pushappearance( void );
int	    mgrib_popappearance( void );
Appearance  *mgrib_setappearance( Appearance* app, int merge );
Appearance  *mgrib_getappearance( void );
int	    mgrib_setcamera( Camera* cam );
mgribcontext *mgrib_newcontext( mgribcontext *ctx );

extern void  mgrib_polygon();
extern void  mgrib_mesh();
extern void  mgrib_line();
extern void  mgrib_polyline();
extern void  mgrib_polylist();

void _mgrib_ctxset(int a1, va_list *alist);

WnWindow *mgribwindow(WnWindow *win);

struct mgfuncs mgribfuncs = {
  MGD_RIB,
  mgdevice_RIB,
  mgrib_feature,
  (mgcontext *(*)())mgrib_ctxcreate,
  mgrib_ctxdelete,
  (void (*)())mgrib_ctxset,
  mgrib_ctxget,
  mgrib_ctxselect,
  mgrib_sync,
  mgrib_worldbegin,
  mgrib_worldend,
  mgrib_reshapeviewport,
  mgrib_settransform,
  mgrib_gettransform,
  mgrib_identity,
  mgrib_transform,
  mgrib_pushtransform,
  mgrib_poptransform,
  mgrib_pushappearance,
  mgrib_popappearance,
  mgrib_setappearance,
  mgrib_getappearance,
  mgrib_setcamera,
  mgrib_polygon,
  mgrib_polylist,
  mgrib_mesh,
  mgrib_line,
  mgrib_polyline
  };

static mgribcontext *MGRIB;	/* For debugging */

int
  mgdevice_RIB()
{
  _mgf = mgribfuncs;
  if (_mgc != NULL && _mgc->devno != MGD_RIB)
    _mgc = NULL;

  return(0);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_ctxcreate
 * Date:	Thu Jul 18 18:55:18 1991
 * Author:	mbp
 * Notes:	see mg.doc for rest of spec
 */
mgcontext *
mgrib_ctxcreate(int a1, ...)
{
  va_list alist;


  _mgc =
    (mgcontext*)(MGRIB = mgrib_newcontext( OOGLNewE(mgribcontext, "mgrib_ctxcreate") ));

  /* Ensure some sensible default Window */
  WnSet(_mgc->win, WN_XSIZE, 300, WN_YSIZE, 200, WN_END);

  va_start(alist, a1);
  _mgrib_ctxset(a1, &alist);
  va_end(alist);
  return _mgc;
}

/*-----------------------------------------------------------------------
 * Function:	_mgrib_ctxset
 * Description:	internal ctxset routine
 * Args:	a1: first attribute
 *		*alist: rest of attribute-value list
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 11:08:13 1991
 * Notes:	mgrib_ctxcreate() and mgrib_ctxset() call this to actually
 *		parse and interpret the attribute list.
 */
void
_mgrib_ctxset(int a1, va_list *alist)
{
  int attr;

  for (attr = a1; attr != MG_END; attr = va_arg (*alist, int)) {
    switch (attr) {
    case MG_ApSet:
      {
	Appearance *ap;

	ap = _ApSet(NULL, va_arg(*alist, int), alist);
	mgrib_setappearance(ap, MG_MERGE);
	ApDelete(ap);
      }
      break;
    case MG_WnSet:
      _WnSet( _mgc->win, va_arg(*alist, int), alist);
      break;
    case MG_CamSet:
      _CamSet( _mgc->cam, va_arg(*alist, int), alist);
      break;
    case MG_APPEAR:
      mgsetappearance(va_arg(*alist, Appearance *), MG_SET);
      break;
    case MG_WINDOW:
      if (_mgc->win) WnDelete(_mgc->win);
      _mgc->win = va_arg(*alist, WnWindow*);
      RefIncr((Ref*) (_mgc->win));
      break;
    case MG_CAMERA:
      mgrib_setcamera( va_arg(*alist, Camera*) );
      break;
    case MG_SETOPTIONS:
      _mgc->opts |= va_arg(*alist, int);
    case MG_UNSETOPTIONS:
      _mgc->opts &= ~va_arg(*alist, int);
      break;
    case MG_SHOW:
      _mgc->shown = va_arg(*alist, int);
      break;
    case MG_PARENT:
      _mgc->parent = va_arg(*alist, mgcontext*);
      break;
    case MG_BACKGROUND:
      _mgc->background = *va_arg(*alist, ColorA*);
      break;
    case MG_ZNUDGE:
      /* for now, read nothing */
      va_arg(*alist, double);
      break;

    /* kind of RIB-specific */
    case MG_RIBFILE:
        if(_mgribc->rib) fclose(_mgribc->rib);
	_mgribc->rib = va_arg(*alist, FILE*);
	break;
    case MG_GEOMTYPE:
	_mgribc->geomtype = va_arg(*alist, int);
	break;

    /* really RIB-specific */
    case MG_RIBLINEMODE:
	_mgribc->line_mode = va_arg(*alist, int);
	break;
    case MG_RIBFORMAT:
	switch( va_arg(*alist, int) ) {
	case MG_RIBASCII:
	    _mgribc->render_device |= RMD_ASCII;
	    _mgribc->render_device &= ~RMD_BINARY; break;
	case MG_RIBBINARY:
	    _mgribc->render_device |= RMD_BINARY;
	    _mgribc->render_device &= ~RMD_ASCII; break;
	}
	break;

    case MG_RIBFILEPATH:
	if(_mgribc->rib) fclose(_mgribc->rib);
	strcpy(_mgribc->filepath, va_arg(*alist, char*));
	_mgribc->rib = fopen(_mgribc->filepath,"w+");
	break;

    default:
    	OOGLError (0, "_mgrib_ctxset: undefined option: %d\n", attr);
    	return;
    	break;
    }
  }

  if (_mgc->shown && !_mgribc->born) {

    /* open the window */
    mgribwindow(_mgc->win);

    /* bring ri state into accordance with appearance state */
    {
      Appearance *ap = ApCopy( &(_mgc->astk->ap), NULL );
      mgrib_setappearance( ap, MG_SET );
      ApDelete(ap);
    }

  }
}


/*-----------------------------------------------------------------------
 * Function:	mgrib_ctxget
 * Description:	get a context attribute value
 * Args:	attr: the attribute to get
 *		value: place to write attr's value
 * Returns:	1 for success; -1 if attr is invalid
 * Author:	mbp
 * Date:	Fri Sep 20 11:50:25 1991
 * Notes:
 */
int
mgrib_ctxget(int attr, void* value)
{
#define VALUE(type) ((type*)value)

  switch (attr) {

  /* Attributes common to all MG contexts: */
  case MG_APPEAR:
    *VALUE(Appearance*) = &(_mgc->astk->ap);
    break;
  case MG_CAMERA:
    *VALUE(Camera*) = _mgc->cam;
    break;
  case  MG_WINDOW:
    if(_mgribc->born) {
    /* COMPLETE THIS! */
    /**/
    /**/
    /**/
    /**/
    }
    *VALUE(WnWindow*) = _mgc->win;
    break;
  case MG_PARENT:
    *VALUE(mgcontext*) = _mgc->parent;
    break;
  case MG_SETOPTIONS:
  case MG_UNSETOPTIONS:
    *VALUE(int) = _mgc->opts;
    break;
  case MG_BACKGROUND:
    *VALUE(ColorA) = _mgc->background;
    break;
  case MG_ZNUDGE:
    /* not implemented now */
    *VALUE(int) = 0;

  /* Attributes specific to RIB contexts: */
  case MG_RIBWINID:
    *VALUE(int) = _mgribc->win;
    break;
  case MG_RIBFILE:
    *VALUE(FILE*) = _mgribc->rib;
     break;
  case MG_GEOMTYPE:
     *VALUE(int) = _mgribc->geomtype;
     break;
  /* Attributes really specific to RI contexts: */
  case MG_RIBLINEMODE:
     *VALUE(int) = _mgribc->line_mode;
	 break;
  case MG_RIBFORMAT:
     if(_mgribc->render_device & RMD_ASCII) *VALUE(int) = MG_RIBASCII;
     if(_mgribc->render_device & RMD_BINARY) *VALUE(int) = MG_RIBBINARY;
	 break;
  case MG_RIBFILEPATH:
     *VALUE(char *) = _mgribc->filepath;
	 break;
  default:
    OOGLError (0, "mgrib_ctxget: undefined option: %d\n", attr);
    return -1;

  }
  return 1;

#undef VALUE
}

/*-----------------------------------------------------------------------
 * Function:	mgribwindow
 * Description:	create a RIB window
 * Args:	*win: the WnWindow structure to realize
 * Returns:	win if success, NULL if not
 * Author:	wisdom, gunn
 * Date:	Fri Sep 20 11:56:31 1991
 * Notes:	makes the RI calls necessary to create a RI window
 *		  corresponding to *win.  This involves the call to
 *		  winopen(), as well as various configuration things
 *		  like RGBmode(), zbuffer(), gconfig(), etc.
 */
WnWindow *
mgribwindow(WnWindow *win)
{
  WnPosition pos;
  int xsize, ysize, flag, reconstrain;
  char *name;
  char gver[80];
  double pxloc, pyloc, pxsize, pysize;
  int noborder=0;

    /* set display characteristics...*/
    mrti(mr_display, mr_string, "image.tiff", mr_file, mr_rgb, mr_NULL);

    /* interpret window ...*/
    /* get the window size */
    mrti(mr_section, "Interpreting Window", mr_NULL);
    WnGet( _mgc->win, WN_XSIZE, &xsize);
    WnGet( _mgc->win, WN_YSIZE, &ysize);
    mrti(mr_format, mr_int, xsize, mr_int, ysize, mr_float, 1., mr_NULL);

    _mgribc->born = 1;
    return(win);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_ctxset
 * Description:	set some context attributes
 * Args:	a1, ...: list of attribute-value pairs
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:00:18 1991
 */
void mgrib_ctxset( int a1, ...  )
{
  va_list alist;

  va_start( alist, a1 );
  _mgrib_ctxset(a1, &alist);
  va_end(alist);
}


/*-----------------------------------------------------------------------
 * Function:	mgrib_feature
 * Description:	report whether the GL device has a particular feature
 * Args:	feature: the feature to report on
 * Returns:	an int giving info about feature
 * Author:	mbp
 * Date:	Fri Sep 20 12:00:58 1991
 * Notes:	-1 means the feature is not present.
 *
 *		THIS IS NOT IMPLEMENTED YET.  ALWAYS RETURNS -1.
 *		WHAT FEATURES ???
 */
int mgrib_feature( int feature )
{
  OOGLError (0, "unimplemented procedure mgrib_feature() called.\n" );
  return(-1);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_ctxdelete
 * Description:	delete a GL context
 * Args:	*ctx: context to delete
 * Returns:	nothing
 * Author:	slevy
 * Date:	Tue Nov 12 10:29:04 CST 1991
 * Notes:	Deleting the current context leaves the current-context
 *		pointer set to NULL.
 */
void mgrib_ctxdelete( mgcontext *ctx )
{
  if(_mgribc->rib) fclose(_mgribc->rib);

  if(ctx->devno != MGD_RIB) {
    mgcontext *was = _mgc;
    mgctxselect(ctx);
    mgctxdelete(ctx);
    if(was != ctx)
	mgctxselect(was);
  } else {
    mg_ctxdelete(ctx);
    if(ctx == _mgc)
	_mgc = NULL;
  }
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_ctxselect
 * Description:	select a RIB context --- make it current
 * Args:	*ctx: the context to become current
 * Returns:	0 (why ???)
 * Author:	mbp, wisdom
 * Date:	Fri Sep 20 12:04:41 1991
 */
int
mgrib_ctxselect( mgcontext *ctx )
{
  if(ctx == NULL || ctx->devno != MGD_RIB) {
    return mg_ctxselect(ctx);
  }

  _mgc = ctx;
  MGRIB = (mgribcontext *)ctx;
  /*
  if(_mgribc->born)
      winset(_mgribc->win);
  */

  return(0);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_sync
 * Description:	flush buffered GL commands
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:06:09 1991
 * Notes:	This is a no-op for GL device.
 */
void
mgrib_sync( void )
{}

/*-----------------------------------------------------------------------
 * Function:	mgrib_worldbegin
 * Description:	prepare to draw a frame
 * Returns:	nothing
 * Author:	gunn, wisdom
 * Date:	Sat Mar  7 16:28:35 GMT-0600 1992
 */
void
mgrib_worldbegin( void )
{
  static Transform cam2ri = {{1, 0,0,0}, {0,1,0,0}, {0,0,-1,0},{0,0,0,1}};
  int persp;
  float fov, aspect, near, far;
  WnWindow *win;
  int xsize, ysize;
  Transform T;
  static Transform *O2SP, *W2SP;	/* to ease gdb'ing */

    /* first, check to see if we need to open the default rib file */
    if(!_mgribc->rib)
    	_mgribc->rib = fopen(DEFAULT_RIB_FILE, "w+");
	
    /* interpret options...(none exist now) */

    /* this will make sure there's nothing left in the rib file */
    /* we cannot use ftruncate because it generates an error on sgi */
    /*ftruncate(fileno(_mgribc->rib), 0);*/
    if (lseek(1, (off_t)0, 0) == (off_t)0 && ftruncate(1, (off_t)0) == -1)
	perror("ftruncate");

    /* interpret camera ...*/
    /* the halfyfield is so confusing that I'm going to ignore it and use fov*/
    /* (gunn) */
    mrti(mr_section, "Interpreting Camera", mr_NULL);
    CamGet( _mgc->cam, CAM_ASPECT, &aspect);
    mrti(mr_screenwindow, mr_float, -aspect, mr_float, aspect,
    	mr_float, -1.0, mr_float, 1.0, mr_NULL);
    CamGet( _mgc->cam, CAM_NEAR, &near);
    CamGet( _mgc->cam, CAM_FAR, &far);
    mrti(mr_clipping, mr_float, near, mr_float, far, mr_NULL);
    CamGet( _mgc->cam, CAM_PERSPECTIVE, &persp);
    CamGet( _mgc->cam, CAM_FOV, &fov);
    mrti(mr_projection, mr_string, persp ? "perspective" : "orthographic",
    	mr_fov, mr_float, fov, mr_NULL);
    mrti(mr_identity, mr_NULL);
    mgrib_printmatrix(cam2ri);
    CamGet(_mgc->cam, CAM_W2C, _mgribc->W2C);
    mgrib_printmatrix(_mgribc->W2C);

    /* Lighting Hack */
   if ( (_mgc->astk->lighting.lights != NULL) &&
      (_mgc->astk->ap.shading != APF_CONSTANT))
    mgrib_lights(_mgc->astk->lighting.lights, _mgc->astk);

    /* RiWorldBegin...*/
    mrti(mr_worldbegin, mr_NULL);

    /* Build camera->screen matrix */

    CamView(_mgc->cam, _mgribc->W2S);	/* world to {-1 .. +1} cube */
    TmTranslate(T, 1.0, 1.0, 0);
    TmConcat(_mgribc->W2S,T, _mgribc->W2S); /* world to {0..2, 0..2, -1..+1} */

    mgrib_ctxget(MG_WINDOW, &win);		/* Gets size of drawing area */
    WnGet(_mgc->win, WN_XSIZE, &xsize);
    WnGet(_mgc->win, WN_YSIZE, &ysize);


    TmScale(T, (double)xsize*.5, (double)ysize*.5, 1.0);
    TmConcat(_mgribc->W2S,T, _mgribc->W2S);	 /* world to window */

    TmCopy(_mgribc->W2S, _mgribc->O2S);	/* initially world == object space */


}

/*-----------------------------------------------------------------------
 * Function:	mgrib_worldend
 * Description:	finish drawing a frame
 * Returns:	nothing
 * Author:	wisdom
 * Date:	Sat Mar  7 14:47:40 GMT-0600 1992
 */
void
mgrib_worldend( void )
{
    unsigned char *buffer = tokenbuffer;
    mrti(mr_worldend, mr_NULL);

    /* now flush the buffer, if appropriate */
    mgrib_flushbuffer();

}

/*-----------------------------------------------------------------------
 * Function:	mgrib_reshapeviewport
 * Description:	adjust to a new window size
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:08:30 1991
 * Notes:	adjusts both GL's internal viewport setting, as well as
 *		MG context WnWindow's current position and camera's
 *		aspect ratio.
 */
void
mgrib_reshapeviewport( void )
{
    WnWindow *win;
    WnPosition wp;
    int xsize, ysize;

    mgrib_ctxget(MG_WINDOW, &win);	/* Get window; force it to ask
					 * NeXTStep how big the window is
					 */
    WnGet(win, WN_CURPOS, &wp);
    xsize = wp.xmax - wp.xmin + 1;
    ysize = wp.ymax - wp.ymin + 1;

    CamSet(_mgc->cam, CAM_ASPECT, (double)xsize/(double)ysize, CAM_END);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_identity
 * Description:	set the current object xform to identity
 * Returns:	nothing
 * Author:
 * Date:
 * Notes:
 *
 */
void
mgrib_identity( void )
{
    OOGLError(1, "Call to unsupported mgrib_identity() -- fix me");
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_transform
 * Description:	premultiply the object xform by T
 * Args:	T
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:24:57 1991
 * Notes:	We use the GL ModelView matrix stack, not the mgcontext's
 *		stack.
 *
 */
void
mgrib_transform( Transform T )
{
    mg_transform(T);
    mgrib_printmatrix(T);
    TmConcat(_mgc->xstk->T, _mgribc->W2S, _mgribc->O2S);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_pushtransform
 * Description:	push the object xform stack
 * Returns:	nothing (???)
 * Author:	mbp
 * Date:	Fri Sep 20 12:25:43 1991
 * Notes:	We use the GL ModelView matrix stack, not the mgcontext's
 *		stack.
 *
 *		This assumes we're already in MVIEWING mode.
 */
int
mgrib_pushtransform( void )
{
    mg_pushtransform();
    mrti(mr_transformbegin, mr_NULL);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_popransform
 * Description:	pop the object xform stack
 * Returns:	nothing (???)
 * Author:	mbp
 * Date:	Fri Sep 20 12:25:43 1991
 * Notes:	We use the GL ModelView matrix stack, not the mgcontext's
 *		stack.
 *
 *		This assumes we're already in MVIEWING mode.
 */
int
mgrib_poptransform( void )
{
    mg_poptransform();
    mrti(mr_transformend, mr_NULL);
    TmConcat(_mgc->xstk->T, _mgribc->W2S, _mgribc->O2S);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_gettransform
 * Description:	get the current object xform
 * Args:	T: place to write the current object xform
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:29:43 1991
 * Notes:	
 *
 *		This assumes we're already in MVIEWING mode.
 */
void
mgrib_gettransform( Transform T )
{
    OOGLError(1, "Call to unsupported mgrib_gettransform() -- fix me");
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_settransform
 * Description:	set the current object xform to T
 * Args:	T
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:29:43 1991
 * Notes:	
 *
 *		This assumes we're already in MVIEWING mode.
 */
void
mgrib_settransform( Transform T )
{
    mg_settransform( T );
    TmConcat(_mgc->xstk->T, _mgribc->W2S, _mgribc->O2S);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_pushappearance
 * Description:	push the MG context appearance stack
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:54:19 1991
 */
int
mgrib_pushappearance( void )
{
  mg_pushappearance();
  mrti(mr_comment, "push appearance", mr_attributebegin, mr_NULL);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_popappearance
 * Description:	pop the MG context appearance stack
 * Returns:	nothing
 * Author:
 * Date:
 * Note:
 */
int
mgrib_popappearance( void )
{
  register struct mgastk *mastk = _mgc->astk;
  register struct mgastk *mastk_next;

  if (! (mastk_next=mastk->next)) {
    OOGLError(0, "mggl_popappearance: appearance stack has only 1 entry.\n");
    return;
  }

  mrti(mr_comment, "pop appearance", mr_attributeend, mr_NULL);

  if ((mastk->light_seq != mastk_next->light_seq) &&    /* changed */
      (mastk->next->ap.shading != APF_CONSTANT))        /* and lighting on */
      mgrib_lighting(mastk_next, mastk_next->lighting.valid);

  mgrib_appearance(mastk_next, mastk_next->ap.valid);

  mg_popappearance();

}

/*-----------------------------------------------------------------------
 * Function:	mgrib_setappearance
 * Author:	munzner, mbp, wisdom
 * Date:	Wed Aug  7 01:08:07 1991
 * Notes:
 */
Appearance *
mgrib_setappearance( Appearance* ap, int mergeflag )
{
  int changed, mat_changed, lng_changed;
  struct mgastk *mastk = _mgc->astk;
  Appearance *ma;
  static float nullarray[] = { 0.0 };

  ma = &(mastk->ap);

  /* Decide what changes */
  if (mergeflag == MG_MERGE) {
    changed = ap->valid & ~ma->override;
    mat_changed =
      ap->mat ? ap->mat->valid & ~ma->mat->override : 0;
    lng_changed =
      ap->lighting ? ap->lighting->valid & ~ma->lighting->override : 0;
  }
  else {
    changed = ap->valid;
    mat_changed = ap->mat ? ap->mat->valid : 0;
    lng_changed = ap->lighting ? ap->lighting->valid : 0;
  }

  mg_setappearance( ap, mergeflag );

  /* here is where everything gets set (sort of) */

  if(_mgribc->born) {
    mgrib_appearance( mastk, changed);

    /* interpret lights ... */
    mgrib_lighting(_mgc->astk, lng_changed);

    if (ap->mat) mgrib_material( mastk, mat_changed );
  }

}


/*-----------------------------------------------------------------------
 * Function:	mgrib_getappearance
 * Description:	return a ptr to current appearance
 * Returns:	ptr to current appearance
 * Author:	mbp
 * Date:	Fri Sep 20 13:00:41 1991
 * Notes:	Applications should not modify the returned appearance
 *		in any way.
 */
Appearance *
mgrib_getappearance()
{
    return &(_mgc->astk->ap);
}

/*-----------------------------------------------------------------------
 * Function:    mgrib_material
 * Description: bind a material. define it if it's not yet defined.
 * Args:        *mat: Material to bind.
 *              mask: Bitmask telling which material fields are valid.
 *                    Passed into mgrib_materialdef.
 * Returns:
 * Author:      gunn
 * Date:        February 8, 1992
 */

void
mgrib_material(struct mgastk *astk, int mask)
{
    Material *mat = &astk->mat;
    char *shader;

    if (mat == NULL) return;


    if((mask & (MTF_EMISSION|MTF_DIFFUSE|MTF_AMBIENT|MTF_SPECULAR
		|MTF_SHININESS|MTF_Kd|MTF_Ka|MTF_Ks|MTF_ALPHA)) == 0)
	return;		/* No rib changes to make. */


    mrti(mr_section, "Interpreting Material", mr_NULL);
    /* for now, extract a plastic shader from the material */
    /* mgrib_fcolor((float *)&mat->diffuse);*/
    mrti(mr_color, mr_parray, 3, &mat->diffuse, mr_NULL);

    if(_mgribc->geomtype==MG_HYPERBOLIC) {
	if(mask &~ APF_EVERT) shader = "heplastic";
	else shader = "hplastic";
    } else {
	if(mask &~ APF_EVERT) shader = "plastic";
	else shader = "plastic";
    }

    if(astk->ap.shading==APF_CONSTANT) {
	mrti(mr_surface, mr_constant, mr_NULL);
    } else {
	mrti(mr_surface, mr_string, shader, mr_Ka, mr_float, mat->ka,
	    mr_Kd, mr_float, mat->kd, mr_Ks, mr_float, mat->ks,
	    mr_specularcolor, mr_parray, 3, &(mat->specular),
	    mr_roughness, mr_float, (mat->shininess)? 1.0/mat->shininess : 1.0,
	    mr_NULL);
    }

}

/*-----------------------------------------------------------------------
 * Function:	mgrib_setcamera
 * Description:	set the context's camera (pointer)
 * Args:	*cam: the camera to use
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 13:07:31 1991
 * Notes:	The context stores a pointer to the camera, not a copy
 *		of it.
 */
int
mgrib_setcamera( Camera* cam )
{
  if (_mgc->cam) CamDelete(_mgc->cam);
  _mgc->cam = cam;
  RefIncr((Ref*) cam);
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_newcontext
 * Description:	initialize a new mgricontext structure
 * Args:	*ctx: the struct to initialize
 * Returns:	ctx
 * Author:	mbp
 * Date:	Fri Sep 20 13:11:03 1991
 */
mgribcontext *
mgrib_newcontext( mgribcontext *ctx )
{
  mg_newcontext(&(ctx->mgctx));
  ctx->mgctx.devfuncs = &mgribfuncs;
  ctx->mgctx.devno = MGD_RIB;
  ctx->mgctx.astk->ap_seq = 1;
  ctx->mgctx.astk->mat_seq = 1;
  ctx->mgctx.astk->light_seq = 1;
  ctx->born = 0;
  ctx->rib = NULL;
  TmIdentity( ctx->W2C );
  TmIdentity( ctx->C2W );

  /* reset the token interface */
  mrti_reset();

  ctx->render_device = RMD_ASCII;
  ctx->line_mode = MG_RIBCYLINDER;

  return ctx;
}

/*-----------------------------------------------------------------------
 * Function:	mgrib_findctx
 * Description: Given a GL window ID, returns the associated mg context.
 * Returns:	mgcontext * for success, NULL if none exists.
 * Author:	slevy
 * Date:	Mon Nov 11 18:33:53 CST 1991
 * Notes:	This is a public routine.
 */
mgcontext *
mgrib_findctx( long winid )
{
  register struct mgcontext *mgc;

  for(mgc = _mgclist; mgc != NULL; mgc = mgc->next) {
    if(mgc->devno == MGD_RIB && ((mgribcontext *)mgc)->win == winid)
	return mgc;
  }
  return NULL;
}

void
mgrib_drawline(HPoint3 *p1, HPoint3 *p2)
{
	if(_mgribc->line_mode==MG_RIBPOLYGON) mgrib_drawPline(p1,p2);
	if(_mgribc->line_mode==MG_RIBCYLINDER) mgrib_drawCline(p1,p2);
	if(_mgribc->line_mode==MG_RIBPRMANLINE)
		NotImplemented("MG_RIBPRMANLINE");
}

void
mgrib_flushbuffer()
{
    unsigned char *buffer = tokenbuffer;
    /* do we even want a buffer anymore? why? */
    if(!_mgribc->rib)
    	_mgribc->rib = fopen(DEFAULT_RIB_FILE, "w+");
    while(buffer<ptr) putc(*(buffer++), _mgribc->rib);
    fflush(_mgribc->rib);
    mrti_reset(_mgribc->rib);
}