#include "mgP.h"
#include "mgriP.h"
#include "mgrishade.h"

mgri_appearance( struct mgastk *astk, int mask )
{
    if(mask & APF_TRANSP) {
        float alpha = astk->mat.alpha;
	/* Quick Renderman does not support opacity */
    }


    if(astk->ap.flag & APF_FACEDRAW && _mgric->drawsfaces == 0) {
    	_mgric->drawsfaces = 1;
	RiGeometricRepresentation("primitive");
    }
    
  /*
   * No GL calls are needed for the following attributes because
   * they are always interpreted at draw-time:
   *            APF_FACEDRAW
   *            APF_EDGEDRAW
   *            APF_NORMSCALE
   *		APF_SHADING/APF_CONSTANT
   *		APF_SHADING/APF_SMOOTH
   *
   * Also, APF_EVERT is handled in mgri_material becuase renderman does
   * this in a shader
   * WHAT ABOUT QUICKRENDERMAN???!
   */
	
}

void mgri_lighting(struct mgastk *astk, int mask)
{
  LtLight *light;
  LmLighting *li = &astk->lighting;
  char lightlabel[8];

  sprintf(lightlabel,"0");
  RiLightSource(lightlabel, RI_AMBIENTLIGHT, RI_LIGHTCOLOR,
      &(li->ambient), RI_NULL);

  /* lights are now defined after camera is defined */
  /* in mgri_worldbegin (it wont work b4 this)      */
  /*mgri_lights( li->lights, astk );*/
}

void
mgri_lights( LtLight *light, struct mgastk *astk )
{
  int i, lightsused;
  int baselight = -1;
  char lightlabel[8];

  lightsused = 0;
  while (light) {
    if (light->private == 0) {
      /* this is a new light */
      if(baselight < 0) {
        register struct mgastk *a;
        for(a = astk, baselight = 1; a != NULL; a = a->next)
            baselight += MAXLIGHTS; /* Count appearance stack depth */
      }
      light->private = lightsused + baselight;
      light->changed = 1;  /* set changed, to force mgri_lightdef below */
    }

    /* string label used by QuickRenderman in RiLightSource */
    sprintf(lightlabel,"%d",light->private);
    
    if (light->position.w == 0.0) {
    	RtPoint lightTo =
	    {-light->position.x, -light->position.y, -light->position.z};
	    
	/* directional light */
	RiLightSource(lightlabel, RI_DISTANTLIGHT, RI_INTENSITY,
	    &light->intensity, RI_LIGHTCOLOR, &(light->color),
	    RI_TO, lightTo, RI_NULL);
	/*
	mrti(mr_comment, "Directional Light",
		mr_lightsource, mr_distantlight, mr_int, light->private,
		mr_intensity, mr_float, light->intensity,
		mr_lightcolor, mr_parray, 3, &(light->color),
		mr_to, mr_array, 3,
		-light->position.x, -light->position.y, -light->position.z,
		mr_NULL);
	*/
    } else {
	/* point light */
	RtPoint frompoint;
	mgri_normalize(&light->position, frompoint); 
	RiLightSource(lightlabel, RI_POINTLIGHT, RI_INTENSITY,
	    &light->intensity, RI_LIGHTCOLOR, &(light->color),
	    RI_FROM, &frompoint,RI_NULL);
	/*
	mrti(mr_lightsource, mr_string, "pointlight", mr_int, light->private,
	    mr_intensity, mr_float, light->intensity,
	    mr_lightcolor, mr_parray, 3, &(light->color),
	    mr_string, "from", mr_parray, 3, &(light->position),
	    mr_NULL);
	*/
    }

    ++lightsused;
    light = light->next;
  }
}
