
#import <appkit/appkit.h>
#import <appkit/graphics.h>
#import <dpsclient/wraps.h>
#import <3Dkit/N3DCamera.h>

#include "mgriP.h"

/* The GVView class is the class which handles drawing */
@interface GVView:N3DCamera
{
}
- initFrame:(const NXRect *)r;
- (RtToken)windowResource;
- windowDidResize:sender;
- windowWillClose:sender;
- windowDidExpose:sender; /* nonretained windows */
- windowWillMiniaturize:sender toMiniwindow:miniwindow;
- windowDidDeminiaturize:sender;
- windowDidBecomeKey:sender;
- display;
@end

@implementation GVView
- initFrame:(const NXRect *)r
{
    [super initFrame:r];
    _mgric->qrmContext = contextToken;
    return self;
}

- (RtToken)windowResource
{
    return windowResource;
}
- windowDidResize:sender
{
    int xsize, ysize;
    mgricontext *thectx =  (mgricontext *)mgri_findctx((char *)sender );

    [window display];
    
    if(thectx!=NULL && thectx->callback!=NULL) {
    	thectx->callback(thectx, MG_RIWINDOWRESIZED);
    }
    return self;
}

- windowWillClose:sender
{
    mgricontext *thectx = (mgricontext *)mgri_findctx((char *)sender );
    if(thectx!=NULL && thectx->callback!=NULL) {
        thectx->dying=1;
    	thectx->callback(thectx, MG_RIWINDOWCLOSED);
	
    }
    return self;
}

- windowWillMiniaturize:sender toMiniwindow:miniwindow
{
    mgricontext *thectx =  (mgricontext *)mgri_findctx((char *)sender );
    if(thectx!=NULL && thectx->callback!=NULL) {
    	thectx->callback(thectx, MG_RIWINDOWICONIFIED);
    }
    return self;
}

- windowDidDeminiaturize:sender
{
    mgricontext *thectx =  (mgricontext *)mgri_findctx((char *)sender );
    if(thectx!=NULL && thectx->callback!=NULL) {
    	thectx->callback(thectx, MG_RIWINDOWDEICONIFIED);
    }
    return self;
}

- windowDidExpose:sender
{
    /* for use with non-retained windows. Is this valid? */
    mgricontext *thectx =  (mgricontext *)mgri_findctx((char *)sender );
    if(thectx!=NULL && thectx->callback!=NULL) {
    	thectx->callback(thectx, MG_RIWINDOWEXPOSED);
    }
    return self;
}

- windowDidBecomeKey:sender
{
    mgricontext *thectx =  (mgricontext *)mgri_findctx((char *)sender );
    if(thectx!=NULL && thectx->callback!=NULL) {
    	thectx->callback(thectx, MG_RIWINDOWBECAMEKEY);
    }
    return self;
}

- display
{
    /*
     * Cameraview erases window here then follows the 3Dkit hierarchy.
     * therefore, we overide this method, because we draw qucikrenderman
     * before this point and don't want it covered up
     */
    return self;
}

@end

int
mgri_nxwindow(int x, int y, int xs, int ys, char *name, int noborder)
{
    NXRect r;
    id dwindow, dview;
    
    /* if the window already exists, return */
    if(_mgric->nxwindow) return 0;
    
    r.origin.x = x;
    r.origin.y = y;
    r.size.width = xs;
    r.size.height = ys;
    
    /* check for application object */
    if(NXApp==NULL) {
        /* we must create an 'application' object */
	/* this creates a connection with the window server */
        NXApp = [Application new];
    }
    
    /* create the window */
    dwindow = (id)_mgric->nxwindow = (char *)[[Window alloc]
    	initContent:&r
	style:noborder ? NX_PLAINSTYLE : NX_RESIZEBARSTYLE
	backing:NX_BUFFERED
	buttonMask:NX_CLOSEBUTTONMASK
		   |NX_MINIATURIZEBUTTONMASK
	defer:NO];

    r.origin.y = 0;
    dview = (id)_mgric->nxview = (char *)[[GVView alloc] initFrame:&r];
    [(id)_mgric->nxview allocateGState]; /* for faster (un)lockfocus */
    
    [[(id)_mgric->nxwindow contentView] addSubview:(id)_mgric->nxview];
    [(id)_mgric->nxwindow setDelegate:(id)_mgric->nxview];
    [(id)_mgric->nxwindow addToEventMask:NX_LMOUSEDRAGGEDMASK];
    [(id)_mgric->nxwindow addToEventMask:NX_RMOUSEDRAGGEDMASK];
    [(id)_mgric->nxwindow addToEventMask:NX_RMOUSEDOWNMASK];
    [(id)_mgric->nxwindow addToEventMask:NX_RMOUSEUPMASK];

	[[(id)_mgric->nxwindow contentView]  setAutoresizeSubviews:YES];
    [(id)_mgric->nxview setAutosizing:NX_WIDTHSIZABLE|NX_HEIGHTSIZABLE];
    [(id)_mgric->nxwindow setTitle:(const char *)name];
    [(id)_mgric->nxwindow display];
    _mgric->windowresource = [(id)_mgric->nxview windowResource];
    [(id)_mgric->nxwindow orderFront:(id)0];
    return 1;
}
   
void
mgri_closewindow(mgricontext *thectx)
{
    /* we must check to see if the window is 'dying', which
     * means the user is closing the window from the title
     * bar & we are in the middle of the windowWillClose method
     * so the window must stick around & will be closed later
     * by the appkit
     */
    if(!thectx->dying) {
	[(id)thectx->nxwindow performClose:(id)0];
	[(id)thectx->nxwindow free];
    }
}

void
mgri_display()
{
    [(id)_mgric->nxview display];
}

void
mgri_getnxrect(float *f)
{
    NXRect theRect;
    [(id)_mgric->nxview getFrame:&theRect];
    f[0]=theRect.origin.x;
    f[1]=theRect.origin.y;
    f[2]=theRect.size.width;
    f[3]=theRect.size.height;
}

void
mgri_clear()
{
  register ColorA *bg;
  register Color *eg;
  NXRect bounds;
  bg=&_mgc->background;
  [(id)_mgric->nxview lockFocus];
  [(id)_mgric->nxview getBounds:&bounds];
  PSsetrgbcolor(bg->r, bg->g, bg->b);
  NXRectFill(&bounds);
  [(id)_mgric->nxview unlockFocus];
  NXPing();
}

void
mgri_flush()
{
    [(id)_mgric->nxwindow flushWindow];
}

RtToken
mgri_windowresource(mgricontext *thectx)
{
    return (thectx->windowresource);
}

void mgri_processevents()
{
    NXEvent theEvent;
    while(DPSGetEvent(DPSGetCurrentContext(), &theEvent, NX_ALLEVENTS,
    	0.0, NX_BASETHRESHOLD))
	{
	    [NXApp sendEvent:&theEvent];
	}
}