#include "mgP.h"
#include "mgriP.h"

#define	HAS_N	0x1
#define	HAS_C	0x2
#define	HAS_SMOOTH 0x4

#define VI_TUPLET_LIMIT 2

int
mgri_mesh( wrap, nu, nv, P, N, C)
    int wrap;
    int nu, nv;
    HPoint3 *P;
    Point3 *N;
    ColorA *C;
{
    register Appearance *ap;
    ColorA	*c;
    Color   *c3;
    Point3  *n;
    void    mgri_submesh();
    int u,v;

    ap = &_mgc->astk->ap;

    if(ap->flag & APF_FACEDRAW) {
	mgri_submesh( wrap, nu, nv, P, N, C);
    }
    
    if(ap->flag & APF_EDGEDRAW) {
    	RiAttributeBegin();
	RiGeometricRepresentation("lines");
	c3 = &ap->mat->edgecolor;
	RiColor((float *)c3);
	mgri_submesh( wrap, nu, nv, P, N, C);
	RiAttributeEnd();
    }
    
    if((ap->flag & APF_NORMALDRAW) && N!=NULL) {
	n = N;
	for(u=0; u<nu; u++)
	for(v=0; v<nv; v++)
	    mgri_drawnormal(P[u + v * nv], n++);
    }
    
    return 1;
}

void
mgri_submesh( wrap, nu, nv, P, N, C)
    int wrap;
    int nu, nv;
    HPoint3 *P;
    Point3 *N;
    ColorA *C;
{
    register Appearance *ap;
    char    *uwrap,*vwrap;
    int     shading;
    int     i;
    register HPoint3 *p;
    register Point3  *n;
    register ColorA	*c;
    int     nunv;
    int     viflag; /* used to insert \n into RIB file so lines */
		    /* won't be to long for 'vi' to work well   */
    float   alpha;
    int colorsdefined;
    int normalsdefined;

    nunv = nu * nv;
    p = P;
    n = N;
    c = C;
	    
    ap = &_mgc->astk->ap;
    
    if(wrap & MM_UWRAP) uwrap = RI_PERIODIC;
    else uwrap = RI_NONPERIODIC;
    
    if(wrap & MM_VWRAP) vwrap = RI_PERIODIC;
    else vwrap = RI_NONPERIODIC;
    
    RiAttributeBegin();

/* THIS SHOULD BE AT A HIGHER LEVEL
    mgri_print("ShadingInterpolation ");
    if(ap->shading & APF_SMOOTH) mgri_print("\"smooth\"\n");
    else mgri_print("\"constant\"\n");
*/

    /* Points */
    /* NOTES: Check to see if we can use Pw here!! */
    for(i=0; i<nunv; i++, p++, viflag++) {
    	mgri_normalize(p, ript[i]);
    }
    
    /* use normals if supplied */
    if(N!=NULL) {
	for(i=0; i<nunv; i++, n++, viflag++) {
	    bcopy((char *)n, (char *)rinormal[i], sizeof(float)*3);
	}
	normalsdefined=1;
    } else normalsdefined=0;
    
    /* use colors if supplied */
    if(C!=NULL) {
	for(i=0; i<nunv; i++, c++, viflag++) {
	    bcopy((char *)c, (char *)ricolor[i], sizeof(float)*3);
	}
	colorsdefined=1;
    } else colorsdefined=0;
	
	/* No Opacity in QuickRenderman */

    /* Define mesh via the renderman interface */
    if(!colorsdefined && normalsdefined)
	RiPatchMesh( RI_BILINEAR, nu, uwrap, nv, vwrap, RI_P, (RtPointer)ript,
	    RI_N, (RtPointer)rinormal, RI_NULL);
    else if(colorsdefined && !normalsdefined)
	RiPatchMesh( RI_BILINEAR, nu, uwrap, nv, vwrap, RI_P, (RtPointer)ript,
	    RI_CS, (RtPointer)ricolor, RI_NULL);
    else if(!colorsdefined && !normalsdefined)
	RiPatchMesh( RI_BILINEAR, nu, uwrap, nv, vwrap, RI_P, (RtPointer)ript,
	    RI_NULL);
    else RiPatchMesh( RI_BILINEAR, nu, uwrap, nv, vwrap, RI_P, (RtPointer)ript,
    	    RI_CS, (RtPointer)ricolor, RI_N, (RtPointer)rinormal, RI_NULL);

    RiAttributeEnd();
}

void
mgri_prmanmesh( wrap, nu, nv, P)
    int wrap;
    int nu, nv;
    HPoint3 *P;
{
    int u;
    int v;
    HPoint3 *p;
    HPoint3 *np;
    int nextu, nextv;
    
    for(u=0; u<nu; u++) {
    for(v=0; v<nv; v++) {
	p = &P[u + v * nv]; /* P[u][v] */
	nextu = u+1;
	if(nextu==nu) {
	    if(wrap & MM_UWRAP)
		np = &P[v * nv]; /* P[u=0][v] */
	    else
		np = NULL;
	}
	if(np!=NULL) mgri_drawline(p,np);
    }
    }

    for(u=0; u<nu; u++) {
    for(v=0; v<nv; v++) {
	p = &P[u + v * nv]; /* P[u][v] */
	nextv = v+1;
	if(nextv==nv) {
	    if(wrap & MM_VWRAP)
		np = &P[u]; /* P[u][v=0] */
	    else
		np = NULL;
	}
	if(np!=NULL) mgri_drawline(p,np);
    }
    }

}
