#include "mgP.h"
#include "mgriP.h"
#include "polylistP.h"

void	mgri_polygon( int nv, HPoint3 *v, int nn, Point3 *n,
	      	          int nc,ColorA *c );
void	mgri_mesh( int wrap,int nu,int nv,HPoint3 *p, Point3 *n,ColorA *c );
void	mgri_line( HPoint3 *p1, HPoint3 *p2 );
void	mgri_polyline( int nv, HPoint3 *verts, int nc, ColorA *colors,
				int wrapped );
void	mgri_polylist(  int np, Poly *p, int nv, Vertex *v, 
			     int plflags );
void	mgri_drawnormal(HPoint3 *p, Point3 *n);
				 

/*-----------------------------------------------------------------------
 * Function:	mgri_polygon
 * Description:	draw a polygon
 * Author:	wisdom
 * Date:	Fri Jan 10 13:57:53 CST 1992
 * Notes:	See mg.doc.
 *
 */
void
mgri_polygon(int nv,  HPoint3 *V, 
	     int nn,  Point3 *N, 
	     int nc,  ColorA *C)
{
  register int i;	
  register HPoint3 *v;
  register Point3 *n;
  register Color *c;
  register ColorA *c4;
  HPoint3 hpt;
  int flag;
  int shading;
  int ninc;
  int colorsdefined;
  int normalsdefined;

    flag = _mgc->astk->ap.flag;
    shading = _mgc->astk->ap.shading;
    ninc = (nn > 1);
    
    /* Process input into a form renderman likes */
     
    
    /* Points */ 
    /* NOTE: although the interface states that points may be described  */
    /* with a 4-vector (x,y,z,w) ala the "Pw" token, I can't seem to get */
    /* it to work with either Photorealistic or Quick Renderman (arg!)   */
    if(nv>0) {
	for(i = 0; i < nv; i++) {
	    /* cannot descibe a polygon using Pw (darnit!), so we normalize */
	    mgri_normalize(&V[i], ript[i]);
	}
    }

    if(flag & APF_FACEDRAW) {
    	/* RGB Color */
	if (nc>0 && !(flag & APF_CONSTANT)) {
	    /* note:color should already be set in case of APF_CONSTANT,no?  */
	    for(i = 0; i < nv; i++) {
		/* if(nc>1) c4 = &C[i]; else c4 = C; */ 
		if(nc>1) bcopy( (char *)&C[i], (char *)ricolor[i], sizeof(float)*3);
		else bcopy( (char *)C, (char *)ricolor[i], sizeof(float)*3);
	    }
	    colorsdefined = 1;
	} else colorsdefined = 0;
    
	/* Opacity is not supported by Quick Renderman, so it is not handled here */
	
	/* Normals */
	if (nn>0 && !(flag & APF_CONSTANT)) {
	    for(i = 0; i < nv; i++) {
		/* if(nn>1) n = &N[i]; else n = N; */
		if(nn>1) bcopy( (char *)&N[i], (char *)rinormal[i], sizeof(float)*3);
		else bcopy( (char *)N, (char *)rinormal[i], sizeof(float)*3);
	    }
	    normalsdefined = 1;
	} else normalsdefined = 0;
	
	/* Define the polygon via the renderman interface */
	if(!colorsdefined && normalsdefined)
	    RiPolygon(nv, RI_P, (RtPointer)ript, RI_N, (RtPointer)rinormal, RI_NULL);
	else if(colorsdefined && !normalsdefined)
	    RiPolygon(nv, RI_P, (RtPointer)ript, RI_CS, (RtPointer)ricolor, RI_NULL);
	else if(!colorsdefined && !normalsdefined)
	    RiPolygon(nv, RI_P, (RtPointer)ript, RI_NULL);
	else RiPolygon(nv, RI_P, (RtPointer)ript, RI_CS, (RtPointer)ricolor,
	    RI_N, (RtPointer)rinormal, RI_NULL);
    }
    
    /* Draw Edges */
    if(flag & APF_EDGEDRAW) {
	c = &_mgc->astk->ap.mat->edgecolor;
	RiAttributeBegin();
	RiColor((float *)c);
	RiGeometricRepresentation("lines");
	RiPolygon(nv, RI_P, (RtPointer)ript, RI_NULL);
	RiAttributeEnd();
    }
    
    /* Draw Normals */
    if(flag & APF_NORMALDRAW) {
    for (n = N, v = V, i = 0; i<nv; ++i, ++v, n += ninc)
	mgri_drawnormal(v, n);
    }
}

/*-----------------------------------------------------------------------
 * Function:	mgri_line
 * Description:	draws a line
 * Author:	wisdom
 * Date:	Fri Jan 17 14:31:06 CST 1992
 * Notes:	see mg.doc
 */
void mgri_line( HPoint3 *p1, HPoint3 *p2 )
{
    mgri_drawline(p1,p2);
}

/*-----------------------------------------------------------------------
 * Function:	mgri_polyline
 * Description:	draws a Polyline
 * Author:	wisdom
 * Date:	Fri Jan 17 14:31:06 CST 1992
 * Notes:	see mg.doc
 */
void mgri_polyline( int nv, HPoint3 *v, int nc, ColorA *c, int wrapped )
{
    ColorA *color;
    
    RiAttributeBegin();
    
    if(nc==0)
	RiColor((float *)&_mgc->astk->mat.edgecolor);

    if(nc==1)
	RiColor((float *)c);

    if(nv == 1) {
	    mgri_drawpoint(v);
    }
    else {
	if(wrapped) {
	    if(nc > 1) {
		color = c + nc - 1;
		RiColor((float *)color);
	    }
	    mgri_drawline(v + nv - 1,v);
	}

	while(--nv > 0) {
	    if(nc > 1) {
		color = c++;
		RiColor((float *)color);
	    }
	    mgri_drawline(v,(v+1));
	    v++;
	}
    }
    
    RiAttributeEnd();
    
}


/*-----------------------------------------------------------------------
 * Function:	mgri_polylist
 * Description:	draws a Polylist: linked list of Polys
 * Author:	wisdom
 * Date:	Wed Jan 22 16:07:03 CST 1992
 * Notes:	see mg.doc
 */
void mgri_polylist( int np, Poly *P, int nv, Vertex *V, int plflags )
{
  register int i,j;
  register Poly *p;
  register Vertex **v, *vp;
  register Point3 *n;
  HPoint3 hpt;
  int flag,shading;
  Color *color;
  ColorA *colorA;
  int colorsdefined;
  int normalsdefined;


    flag = _mgc->astk->ap.flag;
    shading = _mgc->astk->ap.shading;

    if (shading & APF_CONSTANT) plflags &= ~(PL_HASVN|PL_HASPN);
    else if (shading & APF_FLAT) plflags &= ~PL_HASVN;
    else if (shading & APF_SMOOTH) plflags &= ~PL_HASPN;

    if (flag & APF_FACEDRAW) {
    	RiAttributeBegin();
	for (p = P, i = 0; i < np; i++, p++) {

	    /* per polygon color */
	    if (plflags & PL_HASPCOL)
	        RiColor((float *)&p->pcol);
	    
	    /* Points */
	    for (j=0, v=p->v; j < p->n_vertices; j++, v++) {
	        mgri_normalize(&(*v)->pt, ript[j]);
	    }
			    
	    /* colors, if supplied */
	    if(plflags & PL_HASVCOL) {
		for (j=0, v=p->v; j < p->n_vertices; j++, v++) {
		    bcopy((char *)&(*v)->vcol, (char *)ricolor[j], sizeof(float)*3); 
		}
		colorsdefined=1;
	    }
	    else colorsdefined=0;
	    
	    /* Opacity is not supported by Quick Renderman */
	    
	    /* Normals */
	    normalsdefined=0;
	    if(plflags & PL_HASVN) {
		for (j=0, v=p->v; j < p->n_vertices; j++, v++) {
		    bcopy((char *)&((*v)->vn), rinormal[j], sizeof(float)*3);
		}
		normalsdefined=1;
	    } else if(plflags & PL_HASPN) {
		for(j=0, v=p->v; j< p->n_vertices; j++, v++) {
		    bcopy((char *)&(p->pn), (char *)rinormal[j],sizeof(float)*3);
		}
	        normalsdefined=1;
            }
	    
	    /* Define the polygon via the renderman interface */
	    if(!colorsdefined && normalsdefined)
		RiPolygon(p->n_vertices, RI_P, (RtPointer)ript, RI_N,
			(RtPointer)rinormal, RI_NULL);
	    else if(colorsdefined && !normalsdefined)
		RiPolygon(p->n_vertices, RI_P, (RtPointer)ript, RI_CS,
			(RtPointer)ricolor, RI_NULL);
	    else if(!colorsdefined && !normalsdefined)
		RiPolygon(p->n_vertices, RI_P, (RtPointer)ript, RI_NULL);
	    else RiPolygon(p->n_vertices, RI_P, (RtPointer)ript, RI_CS, 
	    	(RtPointer)ricolor, RI_N, (RtPointer)rinormal, RI_NULL);
	    
	}
    	RiAttributeEnd();
    }


    if (flag & APF_EDGEDRAW) {
	color = &_mgc->astk->ap.mat->edgecolor;
	RiAttributeBegin();
	RiColor((float *)color);
	
	for (p = P, i = 0; i < np; i++, p++) {	
	    for (j=0, v=p->v; j < (p->n_vertices-1); j++, v++) {
		mgri_drawline((HPoint3 *)*v,(HPoint3*)*(v+1));
	    }
	    mgri_drawline((HPoint3 *)*v,(HPoint3 *)*(p->v));
	}
	
	RiAttributeEnd();
    }


    if (flag & APF_NORMALDRAW) {
	/* since mg_drawnormal handles attributes and stacking, we do nothing here */
	if (plflags & PL_HASPN) {
	    for (p = P, i = 0; i < np; i++, p++) {
		for (j=0, v=p->v; j < p->n_vertices; j++, v++) {
		    mgri_drawnormal(&(*v)->pt, &p->pn);
		}
	    }
	} else if (plflags & PL_HASVN) {
	    for (vp = V, i = 0; i < nv; i++, vp++) {
		mgri_drawnormal(&vp->pt, &vp->vn);
	    }
	}
    }
    
}

/* There is a basic problem now with 4-d points and 3-d normal vectors.
For now, we'll just ignore the 4-th coordinate of the point when 
computing the tip of the normal vector.  This will work OK with all
existing models, but for genuine 4-d points it won't work.  But,
come to think of it, what is the correct interpretation of the
normal vector when the points live in 4-d?
*/
void
mgri_drawnormal(HPoint3 *p, Point3 *n) {	
    HPoint3 scaledn,end, tp;
    float scale;
    Color *color;
    
    scale = _mgc->astk->ap.nscale;
    if (p->w < 0.0) return;
    HPt3Normalize(p, &tp);
    Pt3Mul(scale, n, &scaledn);
    scaledn.w = 0.0;
    HPt3Add(&tp, &scaledn, &end);
    
    color = &_mgc->astk->mat.normalcolor;

    RiAttributeBegin();
    RiColor((float *)color);
    mgri_drawline(&tp,&end);
    RiAttributeEnd();
    
}
