#include "mgriP.h"
#include "mgrishade.h"
#include <stdio.h>
#include <sys/types.h>

mgcontext * mgri_ctxcreate(int a1, ...);
void	    mgri_ctxset( int a1, ...  );
int	    mgri_feature( int feature );
void	    mgri_ctxdelete( mgcontext *ctx );
int	    mgri_ctxget( int attr, void* valueptr );
int	    mgri_ctxselect( mgcontext *ctx );
void	    mgri_sync( void );
void	    mgri_worldbegin( void );
void	    mgri_worldend( void );
void	    mgri_reshapeviewport( void );
void	    mgri_identity( void );
void	    mgri_transform( Transform T );
int	    mgri_pushtransform( void );
int	    mgri_poptransform( void );
void	    mgri_gettransform( Transform T );
void	    mgri_settransform( Transform T );
void	    mgri_material( struct mgastk *mastk, int merge );
int	    mgri_pushappearance( void );
int	    mgri_popappearance( void );
Appearance  *mgri_setappearance( Appearance* app, int merge );
Appearance  *mgri_getappearance( void );
int	    mgri_setcamera( Camera* cam );
mgricontext *mgri_newcontext( mgricontext *ctx );

extern void  mgri_polygon();
extern void  mgri_mesh();
extern void  mgri_line();
extern void  mgri_polyline();
extern void  mgri_polylist();

void _mgri_ctxset(int a1, va_list *alist);

extern int mgri_nxwindow(int x, int y, int xsize, int ysize,
			char *name, int noborder);
extern void mgri_closewindow(mgricontext *thectx);
extern void mgri_display();
extern void mgri_getnxrect(float *f);
extern void mgri_clear();
extern void mgri_flush();
extern RtToken mgri_windowresource();
extern void mgri_processevents();

WnWindow *mgriwindow(WnWindow *win);

struct mgfuncs mgrifuncs = {
  MGD_RI,
  mgdevice_RI,
  mgri_feature,
  (mgcontext *(*)())mgri_ctxcreate,
  mgri_ctxdelete,
  (void (*)())mgri_ctxset,
  mgri_ctxget,
  mgri_ctxselect,
  mgri_sync,
  mgri_worldbegin,
  mgri_worldend,
  mgri_reshapeviewport,
  mgri_settransform,
  mgri_gettransform,
  mgri_identity,
  mgri_transform,
  mgri_pushtransform,
  mgri_poptransform,
  mgri_pushappearance,
  mgri_popappearance,
  mgri_setappearance,
  mgri_getappearance,
  mgri_setcamera,
  mgri_polygon,
  mgri_polylist,
  mgri_mesh,
  mgri_line,
  mgri_polyline
  };

static mgricontext *MGRI;	/* For debugging */

int
mgdevice_RI()
{
  _mgf = mgrifuncs;
  if (_mgc != NULL && _mgc->devno != MGD_RI)
    _mgc = NULL;

  return(0);
}

/*-----------------------------------------------------------------------
 * Function:	mgri_ctxcreate
 * Date:	Thu Jul 18 18:55:18 1991
 * Author:	mbp
 * Notes:	see mg.doc for rest of spec
 */
mgcontext *
mgri_ctxcreate(int a1, ...)
{
  va_list alist;


  _mgc =
    (mgcontext*)(MGRI = mgri_newcontext( OOGLNewE(mgricontext, "mgri_ctxcreate") ));

  /* Ensure some sensible default Window */
  WnSet(_mgc->win, WN_XSIZE, 500, WN_YSIZE, 400, WN_END);

  va_start(alist, a1);
  _mgri_ctxset(a1, &alist);
  va_end(alist);
  return _mgc;
}

/*-----------------------------------------------------------------------
 * Function:	_mgri_ctxset
 * Description:	internal ctxset routine
 * Args:	a1: first attribute
 *		*alist: rest of attribute-value list
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 11:08:13 1991
 * Notes:	mgri_ctxcreate() and mgri_ctxset() call this to actually
 *		parse and interpret the attribute list.
 */
void
_mgri_ctxset(int a1, va_list *alist)
{
  int attr;

  for (attr = a1; attr != MG_END; attr = va_arg (*alist, int)) {
    switch (attr) {
    case MG_ApSet:
      {
	Appearance *ap;

	ap = _ApSet(NULL, va_arg(*alist, int), alist);
	mgri_setappearance(ap, MG_MERGE);
	ApDelete(ap);
      }
      break;
    case MG_WnSet:
      _WnSet( _mgc->win, va_arg(*alist, int), alist);
      break;
    case MG_CamSet:
      _CamSet( _mgc->cam, va_arg(*alist, int), alist);
      break;
    case MG_APPEAR:
      mgsetappearance(va_arg(*alist, Appearance *), MG_SET);
      break;
    case MG_WINDOW:
      if (_mgc->win) WnDelete(_mgc->win);
      _mgc->win = va_arg(*alist, WnWindow*);
      RefIncr((Ref*) (_mgc->win));
      break;
    case MG_CAMERA:
      mgri_setcamera( va_arg(*alist, Camera*) );
      break;
    case MG_SETOPTIONS:
      _mgc->opts |= va_arg(*alist, int);
    case MG_UNSETOPTIONS:
      _mgc->opts &= ~va_arg(*alist, int);
      break;
    case MG_SHOW:
      _mgc->shown = va_arg(*alist, int);
      break;
    case MG_PARENT:
      _mgc->parent = va_arg(*alist, mgcontext*);
      break;
    case MG_BACKGROUND:
      _mgc->background = *va_arg(*alist, ColorA*);
      break;
    case MG_ZNUDGE:
      /* for now, read nothing */
      va_arg(*alist, double);
      break;
    case MG_GEOMTYPE:
	_mgric->geomtype = va_arg(*alist, int);
	break;

    /* NeXT specific */
    case MG_NXWINDOW:
        _mgric->nxwindow = va_arg(*alist, char *);
	break;	
    case MG_NXVIEW:
        _mgric->nxview = va_arg(*alist, char *);
	break;
    case MG_RICALLBACK:
        _mgric->callback = va_arg(*alist, void *);
	break;
    default:
    	OOGLError (0, "_mgri_ctxset: undefined option: %d\n", attr);
    	return;
    	break;
    }
  }

  if (_mgc->shown && !_mgric->born) {

    /* open the window */
    mgriwindow(_mgc->win);

    /* bring ri state into accordance with appearance state */
    {
      Appearance *ap = ApCopy( &(_mgc->astk->ap), NULL );
      mgri_setappearance( ap, MG_SET );
      ApDelete(ap);
    }

  }
}


/*-----------------------------------------------------------------------
 * Function:	mgri_ctxget
 * Description:	get a context attribute value
 * Args:	attr: the attribute to get
 *		value: place to write attr's value
 * Returns:	1 for success; -1 if attr is invalid
 * Author:	mbp
 * Date:	Fri Sep 20 11:50:25 1991
 * Notes:
 */
int
mgri_ctxget(int attr, void* value)
{
#define VALUE(type) ((type*)value)

  switch (attr) {

  /* Attributes common to all MG contexts: */
  case MG_APPEAR:
    *VALUE(Appearance*) = &(_mgc->astk->ap);
    break;
  case MG_CAMERA:
    *VALUE(Camera*) = _mgc->cam;
    break;
  case  MG_WINDOW:
    if(_mgric->born) {
      WnPosition wp;
      float theRect[4]; /* origin.x, origin.y, size.width, size.height */

      mgri_getnxrect(theRect);
      
      wp.xmin = theRect[0];
      wp.xmax = theRect[0]+theRect[2]-1;
      wp.ymin = theRect[1];
      wp.ymax = theRect[1]+theRect[3]-1;
      WnSet(_mgc->win, WN_CURPOS, &wp, WN_END);
    }
    *VALUE(WnWindow*) = _mgc->win;
    break;
  case MG_PARENT:
    *VALUE(mgcontext*) = _mgc->parent;
    break;
  case MG_SETOPTIONS:
  case MG_UNSETOPTIONS:
    *VALUE(int) = _mgc->opts;
    break;
  case MG_BACKGROUND:
    *VALUE(ColorA) = _mgc->background;
    break;
  case MG_ZNUDGE:
    /* not implimented now */
    *VALUE(int) = 0;

  /* Attributes specific to RI contexts: */
  case MG_RIWINID:
    *VALUE(int) = _mgric->win;
    break;
  case MG_GEOMTYPE:
     *VALUE(int) = _mgric->geomtype;
     break;
  /* specific to NeXT */
  case MG_NXWINDOW:
     *VALUE(char *) = _mgric->nxwindow;
     break;
  case MG_NXVIEW:
     *VALUE(char *) = _mgric->nxview;
     break;
  case MG_RICALLBACK:
     *VALUE(void *) = _mgric->callback;
     break;
  default:
    OOGLError (0, "mgri_ctxget: undefined option: %d\n", attr);
    return -1;

  }
  return 1;

#undef VALUE
}

/*-----------------------------------------------------------------------
 * Function:	mgriwindow
 * Description:	create an RI window
 * Args:	*win: the WnWindow structure to realize
 * Returns:	win if success, NULL if not
 * Author:	wisdom, gunn
 * Date:	Thu May 21 15:04:42 CDT 1992
 * Notes:	makes the RI calls necessary to create a RI window
 *		  corresponding to *win.
 */
WnWindow *
mgriwindow(WnWindow *win)
{
  WnPosition pos;
  int xsize, ysize, flag, reconstrain;
  char *name;
  char gver[80];
  double pxloc, pyloc, pxsize, pysize;
  int noborder=0;

    /* set display characteristics...*/
    //NOW DONE IN mgri_nxwindow() by N3DCamera
    //mrti(mr_display, mr_string, "image.tiff", mr_file, mr_rgb, mr_NULL);
    
    
    /* interpret window ...*/
    /* get the window size */
    WnGet( _mgc->win, WN_XSIZE, &xsize);
    WnGet( _mgc->win, WN_YSIZE, &ysize);
    
    
    /* Now we make the call to actually create the window, if needed */
    
    if(WnGet(win, WN_PREFPOS, (void*)&pos) == 1){
	pxloc = pos.xmin;
	pyloc = pos.ymin;
	pxsize = pos.xmax - pos.xmin;
	pysize = pos.ymax - pos.ymin;
    }
    
    if ((WnGet(win, WN_XSIZE, (void*)&xsize) == 1)
    && (WnGet(win, WN_YSIZE, (void*)&ysize) == 1) ) {
	pxsize = xsize;
	pysize = ysize;
    }
    
    WnGet(win, WN_NOBORDER, &flag);
    if (flag) noborder=1;
    
    WnGet(win, WN_NAME, &name);
    
    mgri_nxwindow(pxloc, pyloc, pxsize, pysize, name, noborder);

    RiGeometricRepresentation("lines");
    RiHider(RI_HIDDEN,RI_NULL);
    RiFormat(pxsize,pysize,1.0);
    
    _mgric->born = 1;
    return(win);
}

/*-----------------------------------------------------------------------
 * Function:	mgri_ctxset
 * Description:	set some context attributes
 * Args:	a1, ...: list of attribute-value pairs
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:00:18 1991
 */
void mgri_ctxset( int a1, ...  )
{
  va_list alist;

  va_start( alist, a1 );
  _mgri_ctxset(a1, &alist);
  va_end(alist);
}


/*-----------------------------------------------------------------------
 * Function:	mgri_feature
 * Description:	report whether the GL device has a particular feature
 * Args:	feature: the feature to report on
 * Returns:	an int giving info about feature
 * Author:	mbp
 * Date:	Fri Sep 20 12:00:58 1991
 * Notes:	-1 means the feature is not present.
 *
 *		THIS IS NOT IMPLEMENTED YET.  ALWAYS RETURNS -1.
 *		WHAT FEATURES ???
 */
int mgri_feature( int feature )
{
  OOGLError (0, "unimplemented procedure mgri_feature() called.\n" );
  return(-1);
}

/*-----------------------------------------------------------------------
 * Function:	mgri_ctxdelete
 * Description:	delete a GL context
 * Args:	*ctx: context to delete
 * Returns:	nothing
 * Author:	slevy
 * Date:	Tue Nov 12 10:29:04 CST 1991
 * Notes:	Deleting the current context leaves the current-context
 *		pointer set to NULL.
 */
void mgri_ctxdelete( mgcontext *ctx )
{
  if(ctx->devno != MGD_RI) {
    mgcontext *was = _mgc;
    mgctxselect(ctx);
    mgctxdelete(ctx);
    if(was != ctx)
	mgctxselect(was);
  } else {
    if(((mgricontext *)ctx)->born)
	mgri_closewindow((mgricontext *)ctx);
    mg_ctxdelete(ctx);
    if(ctx == _mgc)
	_mgc = NULL;
  }
}

/*-----------------------------------------------------------------------
 * Function:	mgri_ctxselect
 * Description:	select an RI context --- make it current
 * Args:	*ctx: the context to become current
 * Returns:	0 (why ???)
 * Author:	mbp, wisdom
 * Date:	Fri Sep 20 12:04:41 1991
 */
int
mgri_ctxselect( mgcontext *ctx )
{
  if(ctx == NULL || ctx->devno != MGD_RI) {
    return mg_ctxselect(ctx);
  }

  _mgc = ctx;
  MGRI = (mgricontext *)ctx;

  if(_mgric->born)
     RiContext(_mgric->qrmContext,RI_NULL);

  return(0);
}

/*-----------------------------------------------------------------------
 * Function:	mgri_sync
 * Description:	flush buffered commands
 * Returns:	nothing
 * Author:	wisdom
 * Date:	Wed May 13 14:34:02 CDT 1992
 * Notes:
 */
void
mgri_sync( void )
{
    RiSynchronize(RI_WAIT);
    mgri_flush();
}

/*-----------------------------------------------------------------------
 * Function:	mgri_worldbegin
 * Description:	prepare to draw a frame
 * Returns:	nothing
 * Author:	gunn, wisdom
 * Date:	Sat Mar  7 16:28:35 GMT-0600 1992
 */
void
mgri_worldbegin( void )
{
  static Transform cam2ri = {{1, 0,0,0}, {0,1,0,0}, {0,0,-1,0},{0,0,0,1}};
  int persp;
  RtFloat fov, aspect, near, far;
  WnWindow *win;
  WnPosition wp;
  int xsize, ysize;
  Transform T;
  RtInt worigin[] = {1, 17};
  
  static Transform *O2SP, *W2SP;	/* to ease gdb'ing */

    /* interpret options...(none exist now) */

    /* interpret camera ...*/
    /* the halfyfield is so confusing that I'm going to ignore it and use fov*/
    /* (gunn) */
    CamGet( _mgc->cam, CAM_ASPECT, &aspect);
    
    /* this may break it */
    WnGet(_mgc->win, WN_CURPOS, &wp);
    xsize = wp.xmax - wp.xmin + 1;
    ysize = wp.ymax - wp.ymin + 1;
    
    /* process any event which may be lying around */
    /* this is an attempt to keep the windowserver from crahsing */
    //mgri_processevents();
    
    RiDisplay(mgri_windowresource(_mgc), RI_FRAMEBUFFER, RI_RGBAZ,
    	RI_ORIGIN, (RtPointer)worigin, RI_NULL);
    RiFormat(xsize,ysize,1.0);

    RiScreenWindow(-aspect, aspect, -1.0, 1.0);
    
    CamGet( _mgc->cam, CAM_NEAR, &near);
    CamGet( _mgc->cam, CAM_FAR, &far);
    //RiClipping(near, far);
    
    CamGet( _mgc->cam, CAM_PERSPECTIVE, &persp);
    CamGet( _mgc->cam, CAM_FOV, &fov);
    if(persp) {
	RiProjection("perspective", "fov", &fov, RI_NULL);
    } else {
        RiProjection("orthographic",RI_NULL);
    }
   
    RiFrameBegin(1);
 
    RiIdentity();
    
    /* NOTE: we may have to play with matrices to make */
    /* renderman like it. probably not, though         */
    RiConcatTransform(cam2ri); //renderman camera looks down -z
    CamGet(_mgc->cam, CAM_W2C, _mgric->W2C);
    RiConcatTransform(_mgric->W2C);

    /* Lighting Hack */
   if ( (_mgc->astk->lighting.lights != NULL) &&
      (_mgc->astk->ap.shading != APF_CONSTANT))
    	mgri_lights(_mgc->astk->lighting.lights, _mgc->astk);
	
    /* RiWorldBegin...*/
    mgri_clear();
    RiWorldBegin();

    /* Build camera->screen matrix */

    CamView(_mgc->cam, _mgric->W2S);	/* world to {-1 .. +1} cube */
    TmTranslate(T, 1.0, 1.0, 0);
    TmConcat(_mgric->W2S,T, _mgric->W2S); /* world to {0..2, 0..2, -1..+1} */

    mgri_ctxget(MG_WINDOW, &win);		/* Gets size of drawing area */
    WnGet(_mgc->win, WN_XSIZE, &xsize);
    WnGet(_mgc->win, WN_YSIZE, &ysize);


    TmScale(T, (double)xsize*.5, (double)ysize*.5, 1.0);
    TmConcat(_mgric->W2S,T, _mgric->W2S);	 /* world to window */

    TmCopy(_mgric->W2S, _mgric->O2S);	/* initially world == object space */

}

/*-----------------------------------------------------------------------
 * Function:	mgri_worldend
 * Description:	finish drawing a frame
 * Returns:	nothing
 * Author:	wisdom
 * Date:	Sat Mar  7 14:47:40 GMT-0600 1992
 */
void
mgri_worldend( void )
{
    RiWorldEnd();
    RiFrameEnd();
    mgri_sync();
}

/*-----------------------------------------------------------------------
 * Function:	mgri_reshapeviewport
 * Description:	adjust to a new window size
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:08:30 1991
 * Notes:	adjusts both GL's internal viewport setting, as well as
 *		MG context WnWindow's current position and camera's
 *		aspect ratio.
 */
void
mgri_reshapeviewport( void )
{
    WnWindow *win;
    WnPosition wp;
    int xsize, ysize;

    mgri_ctxget(MG_WINDOW, &win);	/* Get window; force it to ask
					 * NeXTStep how big the window is
					 */
    WnGet(win, WN_CURPOS, &wp);
    xsize = wp.xmax - wp.xmin + 1;
    ysize = wp.ymax - wp.ymin + 1;

    CamSet(_mgc->cam, CAM_ASPECT, (double)xsize/(double)ysize, CAM_END);

}

/*-----------------------------------------------------------------------
 * Function:	mgri_identity
 * Description:	set the current object xform to identity
 * Returns:	nothing
 * Author:
 * Date:
 * Notes:
 *
 */
void
mgri_identity( void )
{
    OOGLError(1, "Call to unsupported mgri_identity() -- fix me");
    /* NOTE: why don't we usr RiIdentity? */
}

/*-----------------------------------------------------------------------
 * Function:	mgri_transform
 * Description:	premultiply the object xform by T
 * Args:	T
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:24:57 1991
 * Notes:	We use the GL ModelView matrix stack, not the mgcontext's
 *		stack.
 *
 */
void
mgri_transform( Transform T )
{
    mg_transform(T);
    /* NOTE: Will renderman like the order of T? */
    RiConcatTransform(T);
    TmConcat(_mgc->xstk->T, _mgric->W2S, _mgric->O2S);
}

/*-----------------------------------------------------------------------
 * Function:	mgri_pushtransform
 * Description:	push the object xform stack
 * Returns:	nothing (???)
 * Author:	mbp
 * Date:	Fri Sep 20 12:25:43 1991
 * Notes:	We use the GL ModelView matrix stack, not the mgcontext's
 *		stack.
 *
 *		This assumes we're already in MVIEWING mode.
 */
int
mgri_pushtransform( void )
{
    mg_pushtransform();
    RiTransformBegin();
}

/*-----------------------------------------------------------------------
 * Function:	mgri_popransform
 * Description:	pop the object xform stack
 * Returns:	nothing (???)
 * Author:	mbp
 * Date:	Fri Sep 20 12:25:43 1991
 * Notes:	We use the GL ModelView matrix stack, not the mgcontext's
 *		stack.
 *
 *		This assumes we're already in MVIEWING mode.
 */
int
mgri_poptransform( void )
{
    mg_poptransform();
    RiTransformEnd();
    TmConcat(_mgc->xstk->T, _mgric->W2S, _mgric->O2S);
}

/*-----------------------------------------------------------------------
 * Function:	mgri_gettransform
 * Description:	get the current object xform
 * Args:	T: place to write the current object xform
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:29:43 1991
 * Notes:	We use the GL ModelView matrix stack, not the mgcontext's
 *		stack.  This means we must multiply on the right by
 *		the current C2W matrix after reading the GL ModelView
 *		matrix.
 *
 *		This assumes we're already in MVIEWING mode.
 */
void
mgri_gettransform( Transform T )
{
    OOGLError(1, "Call to unsupported mgri_gettransform() -- fix me");
}

/*-----------------------------------------------------------------------
 * Function:	mgri_settransform
 * Description:	set the current object xform to T
 * Args:	T
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:29:43 1991
 * Notes:	We use the GL ModelView matrix stack, not the mgcontext's
 *		stack.  This means we must first load W2C onto the
 *		modelview stact, then premult by T.
 *
 *		This assumes we're already in MVIEWING mode.
 */
void
mgri_settransform( Transform T )
{
    mg_settransform( T );
    TmConcat(_mgc->xstk->T, _mgric->W2S, _mgric->O2S);
}

/*-----------------------------------------------------------------------
 * Function:	mgri_pushappearance
 * Description:	push the MG context appearance stack
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 12:54:19 1991
 */
int
mgri_pushappearance( void )
{
  mg_pushappearance();
  RiAttributeBegin();
}

/*-----------------------------------------------------------------------
 * Function:	mgri_popappearance
 * Description:	pop the MG context appearance stack
 * Returns:	nothing
 * Author:
 * Date:
 * Note:
 */
int
mgri_popappearance( void )
{
  register struct mgastk *mastk = _mgc->astk;
  register struct mgastk *mastk_next;

  if (! (mastk_next=mastk->next)) {
    OOGLError(0, "mggl_popappearance: appearance stack has only 1 entry.\n");
    return;
  }

  RiAttributeEnd();

  if ((mastk->light_seq != mastk_next->light_seq) &&    /* changed */
      (mastk->next->ap.shading != APF_CONSTANT))        /* and lighting on */
      mgri_lighting(mastk_next, mastk_next->lighting.valid);

  mgri_appearance(mastk_next, mastk_next->ap.valid);

  mg_popappearance();


}

/*-----------------------------------------------------------------------
 * Function:	mgri_setappearance
 * Author:	munzner, mbp
 * Date:	Wed Aug  7 01:08:07 1991
 * Notes:
 */
Appearance *
mgri_setappearance( Appearance* ap, int mergeflag )
{
  int changed, mat_changed, lng_changed;
  struct mgastk *mastk = _mgc->astk;
  Appearance *ma;
  static float nullarray[] = { 0.0 };

  ma = &(mastk->ap);

  /* Decide what changes */
  if (mergeflag == MG_MERGE) {
    changed = ap->valid & ~ma->override;
    mat_changed =
      ap->mat ? ap->mat->valid & ~ma->mat->override : 0;
    lng_changed =
      ap->lighting ? ap->lighting->valid & ~ma->lighting->override : 0;
  }
  else {
    changed = ap->valid;
    mat_changed = ap->mat ? ap->mat->valid : 0;
    lng_changed = ap->lighting ? ap->lighting->valid : 0;
  }

  mg_setappearance( ap, mergeflag );

  /* here is where everything gets set (sort of) */

  if(_mgric->born) {
    mgri_appearance( mastk, changed);

    /* interpret lights ... */
    mgri_lighting(_mgc->astk, lng_changed);

    if (ap->mat) mgri_material( mastk, mat_changed );
  }

}


/*-----------------------------------------------------------------------
 * Function:	mgri_getappearance
 * Description:	return a ptr to current appearance
 * Returns:	ptr to current appearance
 * Author:	mbp
 * Date:	Fri Sep 20 13:00:41 1991
 * Notes:	Applications should not modify the returned appearance
 *		in any way.
 */
Appearance *
mgri_getappearance()
{
    return &(_mgc->astk->ap);
}

/*-----------------------------------------------------------------------
 * Function:    mgri_material
 * Description: bind a material. define it if it's not yet defined.
 * Args:        *mat: Material to bind.
 *              mask: Bitmask telling which material fields are valid.
 *                    Passed into mgri_materialdef.
 * Returns:
 * Author:      gunn
 * Date:        February 8, 1992
 */

void
mgri_material(struct mgastk *astk, int mask)
{
    Material *mat = &astk->mat;
    char *shader;

    if (mat == NULL) return;

    if((mask & (MTF_EMISSION|MTF_DIFFUSE|MTF_AMBIENT|MTF_SPECULAR
		|MTF_SHININESS|MTF_Kd|MTF_Ka|MTF_Ks|MTF_ALPHA)) == 0)
	return;		/* No ri changes to make. */


    RiColor((float *)&mat->diffuse);

    /* QuickRenderman supports only simple shaders. We  will */
    /* not use the hplastic, heplastic or eplastic shaders   */
    /*
    if(_mgric->geomtype==MG_HYPERBOLIC) {
	if(mask &~ APF_EVERT) shader = "heplastic";
	else shader = "hplastic";
    } else {
	if(mask &~ APF_EVERT) shader = "plastic";
	else shader = "plastic";
    }
    */

    if(astk->ap.shading==APF_CONSTANT) {
        RiSurface("constant",RI_NULL);
    } else {
        float roughness = (mat->shininess)? 1.0/mat->shininess : 1.0;
        RiSurface("plastic", RI_KA, &mat->ka, RI_KD,&mat->kd,
	    RI_KS, &mat->ks, RI_SPECULARCOLOR, &mat->specular,
	    RI_ROUGHNESS, &roughness, RI_NULL);
	/*
	mrti(mr_surface, mr_string, shader, mr_Ka, mr_float, mat->ka,
	    mr_Kd, mr_float, mat->kd, mr_Ks, mr_float, mat->ks,
	    mr_specularcolor, mr_parray, 3, &(mat->specular),
	    mr_roughness, mr_float, (mat->shininess)? 1.0/mat->shininess : 1.0,
	    mr_NULL);
	*/
    }

}

/*-----------------------------------------------------------------------
 * Function:	mgri_setcamera
 * Description:	set the context's camera (pointer)
 * Args:	*cam: the camera to use
 * Returns:	nothing
 * Author:	mbp
 * Date:	Fri Sep 20 13:07:31 1991
 * Notes:	The context stores a pointer to the camera, not a copy
 *		of it.
 */
int
mgri_setcamera( Camera* cam )
{
  if (_mgc->cam) CamDelete(_mgc->cam);
  _mgc->cam = cam;
  RefIncr((Ref*) cam);
}

/*-----------------------------------------------------------------------
 * Function:	mgri_newcontext
 * Description:	initialize a new mgricontext structure
 * Args:	*ctx: the struct to initialize
 * Returns:	ctx
 * Author:	mbp
 * Date:	Fri Sep 20 13:11:03 1991
 */
mgricontext *
mgri_newcontext( mgricontext *ctx )
{
  mg_newcontext(&(ctx->mgctx));
  ctx->mgctx.devfuncs = &mgrifuncs;
  ctx->mgctx.devno = MGD_RI;
  ctx->mgctx.astk->ap_seq = 1;
  ctx->mgctx.astk->mat_seq = 1;
  ctx->mgctx.astk->light_seq = 1;
  ctx->born = 0;
  ctx->dying = 0;
  ctx->drawsfaces = 0;
  ctx->nxwindow = 0;
  ctx->nxview = 0;
  ctx->callback = NULL;
  TmIdentity( ctx->W2C );
  TmIdentity( ctx->C2W );

  return ctx;
}

/*-----------------------------------------------------------------------
 * Function:	mgri_findctx
 * Description: Given an nxwindow , returns the associated mg context.
 * Returns:	mgcontext * for success, NULL if none exists.
 * Author:	wisdom
 * Date:	Wed May 20 19:22:53 CDT 1992
 * Notes:	This is a public routine.
 */
mgcontext *
mgri_findctx(char *winid)
{
  register struct mgcontext *mgc;

  for(mgc = _mgclist; mgc != NULL; mgc = mgc->next) {
    if(mgc->devno == MGD_RI && ((mgricontext *)mgc)->nxwindow == winid)
	return mgc;
  }
  return NULL;
}

void
mgri_drawline(HPoint3 *p1, HPoint3 *p2)
{    
    mgri_normalize(p1, ript[0]);
    mgri_normalize(p2, ript[1]);
    
    RiLine(2, RI_P, &ript, RI_NULL);
}
