/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "mgP.h"
#include "mgglP.h"
#include "polylistP.h"
#include <gl/gl.h>

void	mggl_polygon( int nv, HPoint3 *v, int nn, Point3 *n,
	      	          int nc,ColorA *c );
void	mggl_mesh( int wrap,int nu,int nv,HPoint3 *p, Point3 *n,ColorA *c );
void	mggl_line( HPoint3 *p1, HPoint3 *p2 );
void	mggl_polyline( int nv, HPoint3 *verts, int nc, ColorA *colors, int wrap );
void	mggl_polylist(  int np, Poly *p, int nv, Vertex *v, 
			     int plflags );
void	mggl_drawnormal(HPoint3 *p, Point3 *n);

void	mggl_closer();
void	mggl_farther();

/*-----------------------------------------------------------------------
 * Function:	mggl_polygon
 * Description:	draw a polygon
 * Author:	mbp, munzner
 * Date:	Mon Jul 29 16:53:56 1991
 * Notes:	See mg.doc.
 *
 *              do later: Different shading cases separated into different
 *		loops for speed.
 */
void
mggl_polygon(int nv,  HPoint3 *V, 
	     int nn,  Point3 *N, 
	     int nc,  ColorA *C)
{
  register int i;	
  register HPoint3 *v;
  register Point3 *n;
  register ColorA *c;
  int cinc, ninc;
  int flag;

  flag = _mgc->astk->ap.flag;
  cinc = (nc > 1);
  ninc = (nn > 1);
  if (_mgc->astk->mat.override & MTF_DIFFUSE) nc = 0;
  
  /* reestablish correct drawing color if necessary */

  if (flag & APF_FACEDRAW) {
    lmcolor(_mgglc->lmcolor);
    if (nc == 0)
	(*_mgglc->d4f)(&(_mgc->astk->ap.mat->diffuse));
    bgnpolygon();
    for (n = N, c = C, v = V, i = 0; i<nv; ++i, ++v) {
	if (nc) { (*_mgglc->d4f)(c); c += cinc; }
	if (nn) { (*_mgglc->n3f)(n,v); n += ninc; }
	v4f((float *)v);
    }
    endpolygon();
  }

  if( flag & (APF_EDGEDRAW|APF_NORMALDRAW) ) {
    if(_mgglc->znudge) mggl_closer();
    lmcolor(LMC_COLOR);
    if (flag & APF_EDGEDRAW) {
	c3f((float *)&_mgc->astk->ap.mat->edgecolor);
	bgnclosedline();
	for (v = V, i = 0; i<nv; ++i, ++v)
	  v4f((float *)v);
	endclosedline();
    }


    if (flag & APF_NORMALDRAW) {
	c3f((float *)&_mgc->astk->ap.mat->normalcolor);
	for (n = N, v = V, i = 0; i<nv; ++i, ++v, n += ninc) {
	    mggl_drawnormal(v, n);
	}
    }
    if(_mgglc->znudge) mggl_farther();
  }
}


void mggl_line( HPoint3 *p1, HPoint3 *p2 )
{
  bgnline();
  v4f((float *)p1);
  v4f((float *)p2);
  endline();
}

void mggl_polyline( int nv, HPoint3 *v, int nc, ColorA *c, int wrapped )
{
  int remain;

  /* note we don't reset to current material color because we could be
   * in the middle of a list of lines and should inherit the color from 
   * the last color call.
   */
  
  if(_mgglc->znudge) mggl_closer();
  if(nc)
      lmcolor(LMC_COLOR);
  if (nv == 1) {
    if(nc > 0) c4f((float *)c);
    pnt(v->x, v->y, v->z);
  } 
  else {
    bgnline();
    if(wrapped) {
      if(nc > 0) c4f((float *)(c + nc - 1));
      v4f((float *)(v + nv - 1));
    }

    remain = 255;
    while(--nv >= 0) {
      if(--remain == 0) {
	if(nc > 0) c4f((float *)c);
	v4f((float *)v);
	endline();
	bgnline();
	remain = 255;
      }
      if(--nc >= 0) c4f((float *)c++);
      v4f((float *)v++);
    }
    endline();
  }
  if(_mgglc->znudge) mggl_farther();
}


/*-----------------------------------------------------------------------
 * Function:	mggl_polylist
 * Description:	draws a Polylist: collection of Polys
 * Author:	munzner
 * Date:	Wed Oct 16 20:21:56 1991
 * Notes:	see mg.doc
 */
void mggl_polylist( int np, Poly *P, int nv, Vertex *V, int plflags )
{
  register int i,j;
  register Poly *p;
  register Vertex **v, *vp;
  register Point3 *n;
  void (*n3func)() = _mgglc->n3f;
  int flag,shading;

  flag = _mgc->astk->ap.flag;
  shading = _mgc->astk->ap.shading;

  if (shading & APF_CONSTANT) plflags &= ~(PL_HASVN|PL_HASPN);
  else if (shading & APF_FLAT) plflags &= ~PL_HASVN;
  else if (shading & APF_SMOOTH) plflags &= ~PL_HASPN;

  if (_mgc->astk->mat.override & MTF_DIFFUSE) 
    plflags &= ~(PL_HASVCOL | PL_HASPCOL);

  if (flag & APF_FACEDRAW) {
    lmcolor(_mgglc->lmcolor);
      /* reestablish correct drawing color if necessary*/
    if (!(plflags & (PL_HASPCOL | PL_HASVCOL)))
	(*_mgglc->d4f)(&(_mgc->astk->ap.mat->diffuse));

    for (p = P, i = 0; i < np; i++, p++) {
      bgnpolygon();
      if (plflags & PL_HASPCOL) (*_mgglc->d4f)(&p->pcol);
      if (plflags & PL_HASPN) (*n3func)(&p->pn, &(*p->v)->pt);
      for (j=0, v=p->v; j < p->n_vertices; j++, v++) {
	if (plflags & PL_HASVCOL) (*_mgglc->d4f)(&(*v)->vcol);
	if (plflags & PL_HASVN) (*n3func)(&(*v)->vn, &(*v)->pt);
	v4f((float *)&(*v)->pt);
      }
      endpolygon();
    }
  }

  if (flag & (APF_EDGEDRAW|APF_NORMALDRAW)) {
    if(_mgglc->znudge) mggl_closer();
    lmcolor(LMC_COLOR);

    if (flag & APF_EDGEDRAW) {
	c3f((float *)&_mgc->astk->ap.mat->edgecolor);
	for (p = P, i = 0; i < np; i++, p++) {
	    bgnclosedline();
	    for (j=0, v=p->v; j < p->n_vertices; j++, v++) {
		v4f((float *)&(*v)->pt);
	    }
	    endclosedline();
	}
    }

    if (flag & APF_NORMALDRAW) {
	c3f((float *)&_mgc->astk->ap.mat->normalcolor);
	if (plflags & PL_HASPN) {
	    for (p = P, i = 0; i < np; i++, p++) {
		for (j=0, v=p->v; j < p->n_vertices; j++, v++)
		  mggl_drawnormal(&(*v)->pt, &p->pn);
	    }
	} else if (plflags & PL_HASVN) {
	    for (vp = V, i = 0; i < nv; i++, vp++) {
		mggl_drawnormal(&vp->pt, &vp->vn);
	    }
	}
    }
    if(_mgglc->znudge) mggl_farther();
  }
}

/*
 * Z-shift routines: for moving edges closer than faces, etc.
 */
mggl_init_zrange()
{
  register struct mgglcontext *gl = _mgglc;

  gl->znudge = _mgc->zfnudge * (gl->zmax - gl->zmin);

  gl->znear = gl->zmin + abs(gl->znudge * MAXZNUDGE);
  gl->zfar = gl->zmax - abs(gl->znudge * MAXZNUDGE);
  lsetdepth(gl->znear, gl->zfar);
}

void
mggl_closer()
{
  lsetdepth( _mgglc->znear -= _mgglc->znudge, _mgglc->zfar -= _mgglc->znudge );
}
void
mggl_farther()
{
  lsetdepth( _mgglc->znear += _mgglc->znudge, _mgglc->zfar += _mgglc->znudge );
}

mggl_findcam()
{
  Transform inv;
  /*
   * Figure out where the camera is in the current coordinate system
   */
  TmInvert(_mgc->xstk->T, inv);
  HPt3TransPt3(inv, &_mgglc->C2W[3][0], &_mgglc->cpos);
  _mgglc->hascpos = 1;
}

/* There is a basic problem now with 4-d points and 3-d normal vectors.
For now, we'll just ignore the 4-th coordinate of the point when 
computing the tip of the normal vector.  This will work OK with all
existing models, but for genuine 4-d points it won't work.  But,
come to think of it, what is the correct interpretation of the
normal vector when the points live in 4-d?
*/
void
mggl_drawnormal(HPoint3 *p, Point3 *n)
{
  HPoint3 scaledn,end, tp;
  float scale;

  if (p->w < 0.0) return;
  HPt3Normalize(p, &tp);

  scale = _mgc->astk->ap.nscale;
  if(_mgc->astk->ap.flag & APF_EVERT) {
    register Point3 *cp = &_mgglc->cpos;
    if(!_mgglc->hascpos)
	mggl_findcam();
    if((p->x-cp->x) * n->x + (p->y-cp->y) * n->y + (p->z-cp->z) * n->z > 0)
	scale = -scale;
  }

  Pt3Mul(scale, n, &scaledn);
  scaledn.w = 0.0;
  HPt3Add(&tp, &scaledn, &end);
  bgnline();
  v4f((float *)&tp);
  v4f((float *)&end);
  endline();
}
