/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef MINNEGRAPHICSDEFS
#define MINNEGRAPHICSDEFS

/*
 * Public interface to mg (minnegraphics) package.
 */

#include "color.h"
#include "point.h"
#include "transform.h"
#include "window.h"
#include "camera.h"
#include "appearance.h"

typedef struct mgcontext mgcontext;	/* Opaque typedef */

struct mgfuncs {  /* mg member functions; potentially changed per device */

  short  	mg_devno;	/* Current device number */

  int		(*mg_setdevice)();
  int		(*mg_feature)(/* int feature */);
  mgcontext *	(*mg_ctxcreate)(/* int a1, ... */);
  void		(*mg_ctxdelete)(/* mgcontext *ctx */);
  void		(*mg_ctxset)(/* a1, ...  */);
  int		(*mg_ctxget)(/* int attr, void* valueptr */);
  int		(*mg_ctxselect)(/* mgcontext *ctx */);
  void		(*mg_sync)(/* void */);
  void		(*mg_worldbegin)(/* void */);
  void		(*mg_worldend)(/* void */);
  void		(*mg_reshapeviewport)(/* void */);
  void		(*mg_settransform)(/* Transform T */);
  void		(*mg_gettransform)(/* Transform T */);
  void		(*mg_identity)(/* void */);
  void		(*mg_transform)(/* const Transform T */);
  int		(*mg_pushtransform)(/* void */);
  int		(*mg_poptransform)(/* void */);
  int		(*mg_pushappearance)(/* void */);
  int		(*mg_popappearance)(/* void */);
  Appearance *	(*mg_setappearance)(/* Appearance* app, int merge */);
  Appearance *	(*mg_getappearance)(/* void */);
  int		(*mg_setcamera)(/* Camera* cam */);
  void		(*mg_polygon)(/* int nv, Point3 *v, int nn,
			        Point3 *n, int nc,ColorA *c */);
  void		(*mg_polylist)(/* int np, Poly *p, int nv, Vertex *v, 
				  int plflags */);
  void		(*mg_mesh)(/* int wrap,int nu,int nv,Point3 *p,
		             Point3 *n,ColorA *c */);
  void		(*mg_line)(/* Point3 *p1, Point3 *p2 */);
  void		(*mg_polyline)(/* int nv, Point3 *v, int nc, ColorA *c, 
				  int wrapped */);
};

extern struct mgfuncs _mgf;

/* Common mg attributes -- for mgctxcreate(), mgctxset(), mgctxget() */

#define MG_END          0
#define	MG_WINDOW	128	/* WnWindow *				*/
#define	MG_PARENT	129	/* mgcontext *context (of parent window)*/
#define	MG_SHOW		130	/* int visible  (make window visible)   */
#define	MG_SETOPTIONS	131	/* int mask (of options to enable) see  */
#define MG_UNSETOPTIONS	132	/* int mask (options to disable)   mg.h */
#define MG_BACKGROUND	133	/* ColorA *				*/
#define	MG_CAMERA	134	/* Camera *				*/
#define MG_APPEAR       135	/* Appearance *default_appearance	*/
#define MG_ApSet        136	/* Appearance create list         	*/
#define MG_WnSet        137	/* Window create list         	*/
#define MG_CamSet       138	/* Camera create list         	*/
#define	MG_ZNUDGE	139	/* float; fraction of Z-range by which lines &
				 * edges are nudged nearer than polygons.
				 */
#define MG_GEOMTYPE     140
#define MG_HYPERBOLIC   141
#define MG_EUCLIDEAN    142

		/* Bitwise ORable options for mg_ctxset MG_[UN]SETOPTIONS */
#define MGO_DOUBLEBUFFER	0x1		/* Default single buffered */
#define MGO_HIDDEN		0x2		/* Default not Z-buffered */
#define MGO_BACKFACECULL	0x4		/* Default back-faces shown */
#define MGO_INHIBITBACKGROUND	0x8		/* Default background drawn */
#define	MGO_INHIBITCLEAR	0x10		/* Default clear at worldbegin*/
#define	MGO_INHIBITSWAP		0x20		/* Default swapbufs at worldend */
		/* mgmesh 'style' values */
#define MM_NOWRAP	0
#define MM_UWRAP	1
#define MM_VWRAP	2

/* mergeflag values for mgsetappearance() */
#define MG_SET		0
#define MG_MERGE	1

#define	mgctxselect( mgc )		(*_mgf.mg_ctxselect)( mgc )
#define mgctxcreate			(*_mgf.mg_ctxcreate)
#define	mgctxdelete( mgc )		(*_mgf.mg_ctxdelete)( mgc )
#define	mgctxset			(*_mgf.mg_ctxset)
#define	mgctxget( attr, valuep )	(*_mgf.mg_ctxget)( attr, valuep )
#define	mgpushappearance()		(*_mgf.mg_pushappearance)()
#define	mgpopappearance()		(*_mgf.mg_popappearance)()


#define	mgsetappearance( ap, merge )	(*_mgf.mg_setappearance)( ap, merge )
#define	mggetappearance()		(*_mgf.mg_getappearance)()
#define	mgsetcamera( cam )			(*_mgf.mg_setcamera)( cam )

#define	mgsettransform( T )		(*_mgf.mg_settransform)( T )
#define mggettransform( T )		(*_mgf.mg_gettransform)( T )
#define	mgidentity()			(*_mgf.mg_identity)()
#define	mgtransform( T )		(*_mgf.mg_transform)( T )
#define	mgpushtransform()		(*_mgf.mg_pushtransform)()
#define	mgpoptransform()		(*_mgf.mg_poptransform)()

#define	mgreshapeviewport()		(*_mgf.mg_reshapeviewport)()


#define	mgworldbegin()			(*_mgf.mg_worldbegin)()
#define	mgsync( )			(*_mgf.mg_sync)()
#define	mgworldend()			(*_mgf.mg_worldend)()

#define	mgpolygon( nv,v, nn,n, nc,c )	(*_mgf.mg_polygon)( nv,v, nn,n, nc,c )
#define	mgpolylist( np,p, nv,v, flags )	(*_mgf.mg_polylist)( np,p, nv,v, flags )
#define	mgmesh( style, nu,nv, v,n,c )	(*_mgf.mg_mesh)( style, nu,nv, v,n,c )
#define	mgline( p1, p2 )		(*_mgf.mg_line)( p1, p2 )
#define	mgpolyline( nv,v, nc,c, wrap )	(*_mgf.mg_polyline)( nv,v, nc,c, wrap )

extern mgcontext *mgcurrentcontext();		/* Get ptr to current context */
extern int mgbegin( void );			/* Init, select default dev */
extern int mgend( void );			/* Shut down */ 

extern mgset4to3( Transform T, int seq );	/* Set 4D->3D transform */
extern int mgget4to3( Transform T );		/* Get 4D->3D; return seq */

	/*
	 * Device select routines -- set default for future mgctxcreate()'s
	 */
extern int mgdevice_GL( void );		
extern int mgdevice_X11( void );
extern int mgdevice_XGL( void );
extern int mgdevice_RIB( void );
extern int mgdevice_RI( void );
extern int mgdevice_PS( void );
extern int mgdevice_VT100( void );
extern int mgdevice_XT( void );
extern int mgdevice_MAC( void );
extern int mgdevice_TEK( void );
extern int mgdevice_TELETYPE( void );
extern int mgdevice_PUNCHCARD( void );
extern int mgdevice_SIMSTIM( void );
extern int mgdevice_NULL( void );

extern int mgdevice( int deviceno );	/* Alternative to the above */

#define  MGD_NODEV	-1	/* error return: can't select that device */
#define  MGD_NULL	0	/* no device, just return current one */
#define  MGD_GL		1	/* SGI GL */
#define  MGD_XGL	2	/* Sun XGL */
#define  MGD_X11	3	/* Generic X11 */
#define	 MGD_RIB	4	/* Renderman RIB*/
#define	 MGD_PS		5	/* Postscript */
#define  MGD_RI		6	/* Quick Renderman */
				/* what else? raster buffer? */

#endif
