/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef LISP_H
#define LISP_H

#include "streampool.h"

#define LLIST	-1
#define LSTRING -2
#define LINT	-3
#define LFLOAT  -4

typedef struct LObject {
  int		type;
  void *	val;
} LObject;

#define LLISTVAL(obj) ((LList*)(obj->val))
#define LSTRINGVAL(obj) ((char*)(obj->val))
#define LINTVAL(obj) (*((int*)(obj->val)))
#define LFLOATVAL(obj) (*((float*)(obj->val)))

extern LObject *Lnil;

typedef struct LList {
  LObject * 	car;
  struct LList *cdr;
} LList;

typedef LObject *(*LObjectFunc)(Pool *p);

char *		LListString(LList *l);
char *		LObjectString(LObject *obj);
LObject *	LListEval(LList *l);
LObject	*	NewLObject(int type);
LObject	*	LEval(LObject *obj);
LObject	*	LSexpr(Pool *p);
void		FreeLObject(LObject *obj);
void		FreeLList(LList *list);
LObject *	LObjectCopy(LObject *obj);
LList *		LListCopy(LList *list);
int		LDefun(char *name, LObjectFunc func);
void		LInit();
LObject *	LEvalSexpr(Pool *p);

#endif /* ! LISP_H */
