/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "vectP.h"
#include "pickP.h"

#define	VSUB3(a, b, dst)  { (dst).x = (a).x - (b).x; (dst).y = (a).y - (b).y; (dst).z = (a).z - (b).z; }

#define	VDOT2(v1, v2)	( (v1).x*(v2).x + (v1).y*(v2).y )

Vect *
VectPick(Vect *v, Pick *p, Appearance *ap, Transform T)
{
    register HPoint3 *hp, *hp0, *hp1;
    Point3 pt0, pt1, pv;
    int picked = -1;
    float w0, w1;
    int e, k, found;

    found = 0;
    for(e = 0, hp = v->p;  e < v->nvec;  e++) {
        hp0 = hp;
	w0 = HPt3TransPt3(T, hp++, &pt0);
	if((k = v->vnvert[e]) == 1) {
	    if(pt0.z < p->got.z && fabs(pt0.x) < p->thresh
				&& fabs(pt0.y) < p->thresh && w0 > 0) {
		picked = e;
		p->got = pt0;
		if (p->want & PW_VERT) {
		  found |= PW_VERT;
		  p->v = pt0;
		}
	    }
	} else {
	    if(k < 0) {
		k = 1-k;
		w1 = HPt3TransPt3(T, hp1=(&hp[k-2]), &pt1);
	    } else {
	        hp1 = hp;
		w1 = HPt3TransPt3(T, hp++, &pt1);
	    }
	    do {
		Point3 near;
		float t;		/* Line parameter "t" */
		Point3 lv;		/* pt1 - pt0 = vector "l" */
					/* pt0 - {0,0} = vector "p" */
		VSUB3(pt1, pt0, lv);
		t = VDOT2(lv, lv);		/* l.l */
		if(t) {
		    t = -VDOT2(pt0, lv) / t;	/* t = p.l / l.l */
		    if(t < 0) t = 0;
		    else if(t > 1) t = 1;
		}
		near.x = pt0.x + lv.x*t;
		near.y = pt0.y + lv.y*t;
		near.z = pt0.z + lv.z*t;
		if(fabs(near.x) <= p->thresh && fabs(near.y) <= p->thresh &&
			near.z < p->got.z && (w0 > 0 || w1 > 0)) {
		    picked = e;
		    p->got = near;
		    if (p->want & PW_EDGE) {
		      found |= PW_EDGE;
		      p->e[0] = pt0;
		      p->e[1] = pt1;
		    }
		    if (p->want & PW_VERT) {
		      if (t < p->thresh) {
			found |= PW_VERT;
			p->v = pt0;
		      } else if (t > 1-p->thresh) {
			found |= PW_VERT;
			p->v = pt1;
		      }
		    }
		}
		pt0 = pt1;
		w0 = w1;
		hp0 = hp1;
		hp1 = hp;
		w1 = HPt3TransPt3(T, hp++, &pt1);
	    } while(--k > 1);
	    hp--;
	}
    }
    if (found) {
      p->found = found;
      TmCopy(T, p->Tprim);
    }
    if(picked >= 0) {
	p->gprim = (Geom *)v;
	return v;
    }
    return NULL;
}
