/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

 /*
  * Geometry Routines
  * 
  * Geometry Supercomputer Project
  * 
  * ROUTINE DESCRIPTION:
  *	Draw a Vect (collection of vectors).
  * 
  */

#include "mg.h"
#include "vectP.h"

Vect *
VectDraw(v)
     register Vect *v;
{
	register HPoint3 *p;
	register ColorA *c, edgecolor;
	HPoint3 *pmax;
	ColorA *cmax;
	register int n, hascolor, nc;
	ColorA *lastcolor=NULL;
	register Appearance *ap = mggetappearance();

	if (v == NULL) return(NULL);
	p = v->p;
	c = v->c;
	hascolor = v->ncolor > 0;
	if (ap->mat && (ap->mat->override & MTF_EDGECOLOR)) hascolor = 0;
	if (!hascolor && ap->mat) {
	  bcopy(&(ap->mat->edgecolor),&edgecolor,sizeof(ap->mat->edgecolor));
	  edgecolor.a = 1;
	  c = &edgecolor;
	  nc = 1;
	}
	pmax = p + v->nvert;
	cmax = c + v->ncolor;

	for(n = 0; n < v->nvec; n++) {
	    register int nv;

	    nv = vcount(v->vnvert[n]);
	    if (hascolor) nc = v->vncolor[n];

	    if(p + nv > pmax || ( hascolor && (c + nc > cmax) ) || nv <= 0 || nc < 0)
		    break;

	    if(nc==0 && lastcolor==NULL)
			mgpolyline(nv,p,nc,c,vwrapped(v->vnvert[n]));
		else if(nc==0)
			mgpolyline(nv,p,1,lastcolor, vwrapped(v->vnvert[n]));
		else mgpolyline(nv,p,nc,lastcolor=c, vwrapped(v->vnvert[n]));

	    p += nv;
	    if (hascolor) c += nc;
	}
	return v;
}

