/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "vectP.h"

static GeomClass *aVectMethods = NULL;

int VectPresent = 1;

static char vectName[] = "vect";

char *
VectName()
{
	return vectName;
}


GeomClass      *
VectMethods()
{
	if (!aVectMethods)
	{
		aVectMethods = GeomClassCreate(vectName);

		aVectMethods->name = VectName;
		aVectMethods->methods = (GeomMethodsFunc *) VectMethods;
		aVectMethods->create = (GeomCreateFunc *) VectCreate;
		aVectMethods->load = (GeomLoadFunc *) VectLoad;
		aVectMethods->fload = (GeomFLoadFunc *) VectFLoad;
		aVectMethods->save = (GeomSaveFunc *) VectSave;
		aVectMethods->fsave = (GeomFSaveFunc *) VectFSave;
		aVectMethods->bound = (GeomBoundFunc *) VectBound;
		aVectMethods->delete = (GeomDeleteFunc *) VectDelete;
		aVectMethods->draw = (GeomDrawFunc *) VectDraw;
		aVectMethods->copy = (GeomCopyFunc *) VectCopy;
		aVectMethods->pick = (GeomPickFunc *) VectPick;
	}
	return aVectMethods;
}
