/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "tlistP.h"

/*
 * Save a Tlist in a file.
 */

Tlist *
TlistFSave(tlist, outf, fname)
    Tlist *tlist;
    FILE *outf;
    char *fname;
{
    if(tlist == NULL || tlist->elements == NULL)
	return NULL;
    fprintf(outf, "TLIST\n");
    if(fputtransform(outf, tlist->nelements, (float *)tlist->elements, 0)
		!= tlist->nelements)
	return NULL;
   if(tlist->tlist != NULL) {
	fprintf(outf, " tlist ");
	GeomFSaveEmbedded( tlist->tlist, tlist->tlisthandle, outf, fname );
   }
   return tlist;
}


Tlist *
TlistSave(tlist, name)
    Tlist *tlist;
    char *name;
{
    Tlist *g;
    FILE *f;

    if(tlist == NULL)
	return NULL;
    if((f = fopen(name, "w")) == NULL)
	return NULL;
    g = TlistFSave(tlist, f, name);
    fclose(f);
    return g;
}
