/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef TLISTDEFS
#define TLISTDEFS
/*
 * Public definitions for a Tlist
 */

#include "tlist.h"
#include "bboxP.h"

#define TLISTMAGIC	 GeomMagic ('t', 1)

typedef struct Tlist Tlist;

extern GeomClass *TlistClass;	/* Our class pointer */

extern GeomClass *TlistMethods( void );

extern Geom  *TlistLoad( char * );
extern Geom  *TlistFLoad( FILE *, char *fname );
extern Tlist *TlistSave( Tlist *, char * );
extern Tlist *TlistFSave( Tlist *, FILE *, char *fname );
extern BBox *TlistBound( Tlist *, Transform );
extern Tlist *TlistTransform( Tlist *, Transform );
extern Tlist *TlistPosition( Tlist *, Transform );
extern Tlist *TlistEvert( Tlist * );
extern Tlist *TlistDraw( Tlist *, Render * );
extern Geom *TlistReplace( Tlist *tlist, Geom *newtlist );
extern int    TlistGet( Tlist *tlist, int attr, void *attrp );
extern Tlist *TlistImport( Pool * );
extern int    TlistExport( Tlist *, Pool * );


#endif /*TLISTDEFS*/
