/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */
static char *copyright = "Copyright (C) 1992 The Geometry Center";

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "tlistP.h"
/*
 * Tlist creation, editing and deletion
 */

void
TlistDelete( register Tlist *tlist )
{
    if(tlist) {
	if(tlist->tlist != NULL) GeomDelete(tlist->tlist);
	if(tlist->tlisthandle != NULL) HandlePDelete(&tlist->tlisthandle);
	if(tlist->elements != NULL) OOGLFree(tlist->elements);
    }
}

Geom *
TlistReplace( register Tlist *tlist, Geom *geom )
{
    register Geom *old;

    if(tlist == NULL)
	return NULL;

    old = tlist->tlist;
    tlist->tlist = geom;
    return old;
}

int
TlistGet( register Tlist *tlist, int attr, register void *attrp )
{
    switch(attr) {
	case CR_GEOM: *(Geom **)attrp = (Geom *)tlist->tlist; break;
	default: return -1;
    }
    return 1;
}
	
Tlist *
TlistCreate(Tlist *exist, GeomClass *classp, va_list a_list)
{
    register Tlist *tlist;
    Geom *g;
    int copy = 1;
    int copyel = 0;
    int attr;
    register int i;
    Transform *elements = (Transform *) NULL;

    if (exist == NULL) {
	tlist = OOGLNewE(Tlist, "TlistCreate tlist");
	tlist->tlisthandle = NULL;
	tlist->tlist = NULL;
	tlist->nelements = 0;
	tlist->elements = NULL;
	GGeomInit (tlist, classp, TLISTMAGIC, NULL);
    } else {
	/* XXX Check that exist is a tlist. */
	tlist = exist;
    }

    while (attr = va_arg (a_list, int)) switch(attr) {
	case CR_UNIT:
	    g = va_arg (a_list, Geom *);
	    if(copy) RefIncr((Ref *)g);
	    if(tlist->tlist) GeomDelete(tlist->tlist);
	    tlist->tlist = g;
	    break;
	case CR_ELEM:
	    elements = va_arg (a_list, Transform *);
	    copyel = copy;
	    break;
	case CR_NELEM:
	    tlist->nelements = va_arg (a_list, int);
	    if (tlist->elements != NULL) {
		OOGLFree (tlist->elements);
		tlist->elements = NULL;
	    }
	    break;
	default:
	    if(GeomDecorate(tlist, &copy, attr, &a_list)) {
		OOGLError (0, "TlistCreate: undefined option: %d", attr);
		if (exist == NULL) GeomDelete ((Geom *) tlist);
		return NULL;
	    }
    }

    if ((tlist->elements == NULL) && (tlist->nelements > 0)) {
	if (elements != NULL && !copyel)
	    tlist->elements = elements;
	else {
	    tlist->elements = OOGLNewNE(Transform, tlist->nelements,
				"TlistCreate: matrices");
	    if (elements == NULL) 
		for (i=0; i<tlist->nelements; i++)
		    TmIdentity (tlist->elements[i] );
	    else
		bcopy (elements, tlist->elements,
				tlist->nelements*sizeof (Transform));
	}    
    }

    return tlist;
}
