/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <math.h>
#include "quadP.h"
#include "polylistP.h"
#include "pickP.h"


/*

NOTE: this code currently uses PolyPick() which is part of the
polylist picking code (plpick.c).  Ideally that routine should be
taken out of plpick.c and turned into a more general utility that can
be used for picking of all polygonal data (polylists, quads, and
meshes).  For now, however, in the interest of getting something
working as soon as possible, we resort to this messy kludge.

mbp Tue Mar 24 15:51:14 1992 

I'm just stealing the code out of meshpick: I wonder how long these
kludges will stay in the code til we get motivated to do it right?

tmm Tue Apr 14 00:40:53 1992 

*/

extern int PolyPick(Poly *poly, Pick *p, Appearance *ap, Transform T);

/* MESHPOINT(u,v) uses variables p, nu, nv */
#define MESHPOINT(u,v) *(p + (v%nv)*nu + (u%nu))

Quad *
QuadPick(Quad *quad, Pick *pick, Appearance *ap, Transform T)
{
  int i;
  int found;
  HPoint3 *p;
  static Vertex verts[4];
  static Vertex *vps[4] = { &verts[0], &verts[1], &verts[2], &verts[3] };
  static Poly poly = { 4, vps };

  found = 0;
  if((p = quad->p[0]) == NULL)
    return NULL;
  for (i = 0; i < quad->maxquad; i++) {
    verts[0].pt = *p++;
    verts[1].pt = *p++;
    verts[2].pt = *p++;
    verts[3].pt = *p++;

    found |= PolyPick(&poly, pick, ap, T);
  }
  return found ? quad : NULL;
}
