/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "quadP.h"
#include "mg.h"

Quad *
QuadDraw(register Quad *quad)
{
    register HPoint3 *p;
    register Point3  *n;
    register ColorA *c;
    int i, nc, nn;

    if (quad == NULL)
      return NULL;

    if ((quad->flag & VERT_N) == 0) {
	register Appearance *ap = mggetappearance();

	if(ap->valid & APF_NORMSCALE ||
		(ap->flag & APF_FACEDRAW && ap->shading != APF_CONSTANT)) {
	    QuadComputeNormals(quad, NULL);
	    quad->flag |= VERT_N;
	}
    }
    nc = quad->flag & VERT_C ? 4 : 0;
    nn = quad->flag & VERT_N ? 4 : 0;
    p = quad->p[0];
    n = quad->n[0];
    c = quad->c[0];

    for(i = quad->maxquad; --i >= 0; p += 4, n += nn, c += nc)
	mgpolygon( 4, p, nn, n, nc, c );

    return quad;
}

