/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "quadP.h"

BBox *
QuadBound( quad, T )
    Quad *quad;
    Transform T;
{
    register int v;
    HPoint3 min, max;
    register HPoint3 *p;
    HPoint3	*raw, *clean, p0, p1;

    p = quad->p[0];
    min = *p;
    if (T && T != TM_IDENTITY) 	{
    	HPt3Transform(T, &min, &min);
    	/*  if (quad->flag & QUAD_4D) */
	HPt3Normalize( &min, &min );
    	}
    max = min;
    clean = &p1;
    for( v = 4 * quad->maxquad; --v > 0; ) {
        p++;
        if (T && T != TM_IDENTITY) 	{
        	HPt3Transform(T, p, &p0);
        	raw = &p0;
        	}
        else raw = p;
        /*  if (polylist->flags &PL_4D)   */
        HPt3Normalize( raw , clean );
        if(min.x > clean->x) min.x = clean->x;
        else if(max.x < clean->x) max.x = clean->x;
        if(min.y > clean->y) min.y = clean->y;
        else if(max.y < clean->y) max.y = clean->y;
        if(min.z > clean->z) min.z = clean->z;
        else if(max.z < clean->z) max.z = clean->z;
        }
    
    return (BBox *) GeomCreate ("bbox", CR_MIN, &min, CR_MAX, &max, NULL);
}

