/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * Save a PolyList (in .off format).
 */

#include "polylistP.h"

PolyList *
PolyListFSave(polylist, outf, fname)
	register PolyList *polylist;	/* Thing to save */
	FILE *outf;			/* Stream to save it on */
	char *fname;			/* File name for error msgs */
{
	register int i, n;
	register Poly *p;
	register Vertex **vp, *v;
	ColorA *c;

	/* We don't really know the number of edges and it's a pain to count.
	 * Assume Euler number 2.
	 */
	fprintf(outf, "%s%sOFF\n%d %d %d\n",
		&"C"[polylist->flags & PL_HASVCOL ? 0 : 1],
		&"N"[polylist->flags & PL_HASVN ? 0 : 1],
		polylist->n_verts, polylist->n_polys,
		polylist->n_verts + polylist->n_polys - 2);

	for(i = polylist->n_verts, v = polylist->vl; --i >= 0; v++) {
	    fprintf(outf, "\n%g %g %g", v->pt.x, v->pt.y, v->pt.z);
	    if(polylist->flags & PL_HASVN)
		fprintf(outf, "  %g %g %g", v->vn.x, v->vn.y, v->vn.z);
	    if(polylist->flags & PL_HASVCOL)
		fprintf(outf, "  %g %g %g %g",
			v->vcol.r, v->vcol.g, v->vcol.b, v->vcol.a);
	}

	fputc('\n', outf);
	for(i = polylist->n_polys, p = polylist->p; --i >= 0; p++) {
	    n = p->n_vertices;
	    fprintf(outf, "\n%d	", n);
	    for(vp = p->v; --n >= 0; vp++)
		fprintf(outf, " %d", (*vp) - polylist->vl);
	    if((polylist->flags & (PL_HASPCOL|PL_HASVCOL)) == PL_HASPCOL) {
		fprintf(outf, "\t%d %d %d",
		    (int)(p->pcol.r * 255), (int)(p->pcol.g * 255),
		    (int)(p->pcol.b * 255));
	    }
	}
	fputc('\n', outf);

	return (ferror(outf) ? NULL : polylist);

}


PolyList *
PolyListSave(PolyList *polylist, char *name)
{
	FILE	*f;
	PolyList *result;

	if((f = fopen(name, "w")) == NULL) {
		return NULL;
	}
	result = PolyListFSave(polylist, f, name);
	fclose(f);
	return(result);
}
