/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * Compute the normals to each surface in a polylist.
 */


#include "polylistP.h"

PolyList *
PolyListComputeNormals( PolyList *polylist )
{
	register int	i, n;
	float           len;
	register Poly	*p;
	Vertex		**vp;
	register Vertex	*v, *v2, *v3;
	register float	x, y, z;

	if(!(polylist->flags & PL_HASPN)) {
	    /* Create per-polygon normals */
	    for (i = polylist->n_polys, p = polylist->p; --i >= 0; p++) {
		x = y = z = 0.0;
		if((n = p->n_vertices) >= 3) {
		    v = p->v[n-2];
		    v2 = p->v[n-1];
		    vp = p->v;

#define ANTI(P,Q)  (v2->pt.P - v->pt.P) * (v3->pt.Q - v->pt.Q) - \
		   (v2->pt.Q - v->pt.Q) * (v3->pt.P - v->pt.P)

		    do {
			v3 = *vp;
			x += ANTI(y,z);
			y += ANTI(z,x);
			z += ANTI(x,y);
			v = v2;
			v2 = v3;
			vp++;
		    } while(--n > 0);
		    len = sqrt(x*x + y*y + z*z);
		    if(len > 0.0) {
			if(polylist->flags & PL_EVNORM)
			    len = -len;
			x /= len;
			y /= len;
			z /= len;
		    }
		    p->pn.x = x;
		    p->pn.y = y;
		    p->pn.z = z;
		}
	    }
	    polylist->flags |= PL_HASPN;
	}

	if(!(polylist->flags & PL_HASVN)) {
	    
	    for(i = polylist->n_verts, v = polylist->vl; --i >= 0; v++) {
		v->vn.x = v->vn.y = v->vn.z = 0.0;
	    }
	    for(i = polylist->n_polys, p = polylist->p; --i >= 0; p++) {
		for(n = p->n_vertices, vp = p->v; --n >= 0; vp++) {
		    v = *vp;
		    v->vn.x += p->pn.x;
		    v->vn.y += p->pn.y;
		    v->vn.z += p->pn.z;
		}
	    }
	    for(i = polylist->n_verts, v = polylist->vl; --i >= 0; v++) {
		len = sqrt(v->vn.x*v->vn.x + v->vn.y*v->vn.y + v->vn.z*v->vn.z);
		if(len > 0) {
		    if(polylist->flags & PL_EVNORM)
			len = -len;
		    v->vn.x /= len;
		    v->vn.y /= len;
		    v->vn.z /= len;
		}
	    }
	    polylist->flags |= PL_HASVN;
	}

	return polylist;
}
