/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/* $Header: /usr8/geom/devel/ngrap/src/lib/gprim/polylist/RCS/pldraw.c,v 1.15 1992/01/31 16:15:29 mbp Exp $ */

/*
 * Draw a PolyList using mg library.
 */

#include "polylistP.h"
#include "appearance.h"
#include "mg.h"

PolyList *
PolyListDraw( register PolyList *polylist )
{
    if (polylist == NULL)
      return NULL;
    
    /*
     * The drawing routines might need either polygon or vertex normals,
     * so if either is missing and either might be needed,
     * we force it to be computed.
     */
    if((polylist->flags & (PL_HASVN|PL_HASPN)) != (PL_HASVN|PL_HASPN)) {
	register Appearance *ap = mggetappearance();
	if((ap->shading != APF_CONSTANT && ap->flag & APF_FACEDRAW)
			|| ap->flag & APF_NORMSCALE)
	    PolyListComputeNormals(polylist, NULL);
    }

    mgpolylist(polylist->n_polys, polylist->p, polylist->n_verts, polylist->vl,
		polylist->flags);
    return polylist;
}
