/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */
static char *copyright = "Copyright (C) 1992 The Geometry Center";

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * PolyList creation, editing, and deletion.
 */
#include "polylistP.h"


 /*
  * Free a PolyList. 
  */

#include "polylistP.h"

PolyList *
PolyListDelete( register PolyList *pl )
{
    register int i;
    register Poly *p;
    
    if (pl == NULL)
	return NULL;

    if((p = pl->p) != NULL) {
	for(i = pl->n_polys; --i >= 0; p++)
	    if(p->v != NULL) OOGLFree(p->v);
	OOGLFree(pl->p);
    }
    if(pl->vl != NULL)
	OOGLFree(pl->vl);

    return NULL;
}

PolyList *
PolyListCreate(PolyList *exist, GeomClass *classp, va_list a_list)
{
   register PolyList *pl;
   register Vertex *v;
   int *nvertperpol=NULL, *verts=NULL;
   int npolyflag=0, nvertflag=0, vertflag=0, pointflag=0;
   HPoint3 *v4 = NULL;
   Point3 *v3 = NULL, *vn = NULL, *pn = NULL;
   ColorA *vc = NULL, *pc = NULL;
   int attr, copy=1;
   int numentries=0, numvertices=0;
   register int i;
   int j,k=0, dimn = 3;

   if (exist == NULL) {
      pl = OOGLNewE(PolyList,"PolyListCreate polylist");
      GGeomInit(pl, classp, PLMAGIC, NULL);
      pl->flags = pl->n_polys = pl->n_verts = 0;
      pl->p = (Poly *)NULL; pl->vl = (Vertex *)NULL;
   } else {
   int j,k=0;
      pl = exist;
   }


   while (attr = va_arg(a_list, int)) 
     switch (attr) {

       case CR_NOCOPY:
          OOGLError(0,"Note: NOCOPY option not used by PolyListCreate()");
          break;

       case CR_FLAG:
          pl->flags = va_arg(a_list, int);
          break;

       case CR_NPOLY:
          pl->n_polys = va_arg(a_list, int);
          npolyflag = 1;
          break;

       case CR_NVERT:	/* number of verts of each polygon */
          nvertperpol = va_arg(a_list, int*);
          nvertflag = 1;
          break;

       case CR_VERT:	/* indices of all verts of all polygons, concatenated */
			/* verts[] contains sum(nvertperpol[]) elements */
          verts = va_arg(a_list, int*);
          vertflag = 1;
          break;

       case CR_POINT:
          v3 = va_arg(a_list, Point3 *);
          pointflag = 1;
	  dimn = 3;
          break;

       case CR_POINT4:
          v4 = va_arg(a_list, HPoint3 *);
          pointflag = 1;
	  dimn = 4;
          break;

       case CR_NORMAL:
          vn = va_arg(a_list, Point3 *);
          pl->flags |= PL_HASVN;
          break;

       case CR_COLOR:
          vc = va_arg(a_list, ColorA *);
          pl->flags |= PL_HASVCOL;
          break;

       case CR_POLYNORMAL:
          pn = va_arg(a_list, Point3 *);
          pl->flags |= PL_HASPN;
          break;

       case CR_POLYCOLOR:
          pc = va_arg(a_list, ColorA *);
          pl->flags |= PL_HASPCOL;
          break;

       default:
          if (GeomDecorate(pl, &copy, attr, &a_list)) {
             OOGLError(0,"Undefined PolyList option: %d", attr);
             if (!exist) GeomDelete((Geom *)pl);
             return NULL;
	}
    }

    if (!exist && (!npolyflag || !nvertflag || !vertflag || !pointflag)) {
	if (!npolyflag) OOGLError(0,"Must specify number of polygons");
	if (!nvertflag) OOGLError(0,"Must specify NVERT array");
	if (!vertflag) OOGLError(0,"Must specify VERT array");
	if (!pointflag) OOGLError(0,"Must specify vertices");
	GeomDelete((Geom *)pl);
	return NULL;
    }


    if(nvertflag) {
	for (i=0; i<pl->n_polys; i++)
	    numentries += nvertperpol[i];
	for (i=0; i<numentries; i++) 
	    if (verts[i] > numvertices)
		numvertices = verts[i];
	pl->n_verts = numvertices + 1;
	if(pl->vl)
	    OOGLFree(pl->vl);
	pl->vl = OOGLNewNE(Vertex, pl->n_verts, "polylist vertices");
    }
    if(pointflag) {
	/* if dimn == 3, copy over into 4-vector area and add a '1' in
	 * the 4th coordinate */
	v = pl->vl;
	i = pl->n_verts;
	if (dimn == 3) {
	    while(--i >= 0) {
		*(Point3 *)&(v->pt) = *v3++;
		v->pt.w = 1.0;
		v++;
	    }
	} else {
	    while(--i >= 0) {
		v->pt = *v4++;
		v++;
	    }
	}
    }
    if(nvertflag) {
	
	pl->p = OOGLNewNE(Poly, pl->n_polys, "PolyListCreate polygons");
	k = 0;
	for (i=0; i<pl->n_polys; i++) {
	    int nv = nvertperpol[i];
	    pl->p[i].n_vertices = nv;
	    pl->p[i].v =
		    OOGLNewNE(Vertex *, nvertperpol[i],
			    "PolyListCreate poly vert pointers");
	    for (j = 0; j < nv; j++)
		pl->p[i].v[j] = &pl->vl[verts[k++]];
	}
    }

    if (vn)
	for (i = pl->n_verts, v = pl->vl; --i >= 0; v++)
	    v->vn = vn[i];

    if (vc)
	for (i = 0, v = pl->vl; i < pl->n_verts; i++, v++)
	    v->vcol = vc[i];

    if (pn)
	for (i = pl->n_polys; --i >= 0; )
	    pl->p[i].pn = pn[i];

    if (pc)
	for (i = pl->n_polys; --i >= 0; )
	    pl->p[i].pcol = pc[i];

    return pl;
}
