/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * Geometry Routines
 *
 * Geometry Supercomputer Project
 *
 * ROUTINE DESCRIPTION:  Return the bounding box of a polylist.
 *
 */


#include "polylistP.h"

BBox *
PolyListBound(polylist, T)
     PolyList       *polylist;
     Transform	T;
{
	register int n;
	register Vertex	*v;
	HPoint3	min, max;
	HPoint3	*raw, *clean, p0, p1;
	
	n = polylist->n_verts;
	v = polylist->vl;
	/* We assume all the vertices in vl[] are actually used... */
	while(--n >= 0 && !finite(v->pt.x + v->pt.y + v->pt.z))
	v++;
	if(n <= 0)
	return NULL;	/* No finite points */
	min = v->pt;
	/* all points are 4-vectors, but we've marked whether they
	 * have true 4-dimensional nature */
	if (T) 	{
		HPt3Transform(T, &min, &min);
		/*   if (polylist->flags & PL_4D)   */
	    	HPt3Normalize( &min, &min );
		}
	max = min;
	clean = &p1;
	while(--n >= 0) {
		v++;
            	if (T && T != TM_IDENTITY) 	{
			HPt3Transform(T, &v->pt, &p0);
			raw = &p0;
			}
		else raw = &v->pt;
		/*  if (polylist->flags &PL_4D)   */
		HPt3Normalize( raw , clean );
		if(min.x > clean->x) min.x = clean->x;
		else if(max.x < clean->x) max.x = clean->x;
		if(min.y > clean->y) min.y = clean->y;
		else if(max.y < clean->y) max.y = clean->y;
		if(min.z > clean->z) min.z = clean->z;
		else if(max.z < clean->z) max.z = clean->z;
		}
	return (BBox *) GeomCCreate(NULL, BBoxMethods(),
			    CR_MIN, &min, CR_MAX, &max, CR_END);
}
