/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "meshP.h"

#ifdef GEOM_SM

GeomRef
MeshShare(obj, sm)
Geom           *obj;
GeomSMRegion   *sm;
{
	GeomSMRegion   *osm;
	GeomRef         newobj;
	Mesh           *m;

	/*
	 * Just check the first item on the data list, assume the whole list is in the same area. Note: this
	 * won't work for hierarchy objects!
	 */
	if (obj == NULL || (m = (Mesh *) obj->object) == NULL)
		return (NULL);
	if (IsInSM(m, sm) && IsInSM(m->p, sm) &&
	    (m->u == NULL || IsInSM(m->u, sm)) &&
	    (m->c == NULL || IsInSM(m->c, sm)) &&
	    (m->n == NULL || IsInSM(m->n, sm)) &&
	    (m->d == NULL || IsInSM(m->d, sm)) &&
	    (m->nd == NULL || IsInSM(m->nd, sm)))
		return (obj->object);

	/* Nope, must copy it */

	osm = GeomCurSM;
	GeomUseMem(sm);
	newobj = (GeomRef) MeshCopy((Mesh *) obj->object);
	GeomUseMem(osm);
	return (newobj);
}
#endif
