/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <math.h>
#include "meshP.h"
#include "polylistP.h"
#include "pickP.h"


/*

NOTE: this code currently uses PolyPick() which is part of the
polylist picking code (plpick.c).  Ideally that routine should be
taken out of plpick.c and turned into a more general utility that can
be used for picking of all polygonal data (polylists, quads, and
meshes).  For now, however, in the interest of getting something
working as soon as possible, we resort to this messy kludge.

mbp Tue Mar 24 15:51:14 1992

*/

extern int PolyPick(Poly *poly, Pick *p, Appearance *ap, Transform T);

/* MESHPOINT(u,v) uses variables p, nu, nv */
#define MESHPOINT(u,v) *(p + (v%nv)*nu + (u%nu))

Mesh *
MeshPick(Mesh *mesh, Pick *pick, Appearance *ap, Transform T)
{
  int u,v,nu,nv, maxu, maxv, found;
  HPoint3 *p;
  static Poly *poly;

  if (!poly) {
    poly = OOGLNewE(Poly, "Poly");
    poly->n_vertices = 4;
    poly->v = OOGLNewNE(Vertex*, 4, "Vertex*");
    poly->v[0] = OOGLNewE(Vertex, "Vertex");
    poly->v[1] = OOGLNewE(Vertex, "Vertex");
    poly->v[2] = OOGLNewE(Vertex, "Vertex");
    poly->v[3] = OOGLNewE(Vertex, "Vertex");
  }

  p = mesh->p;
  nu = nuverts(mesh);
  nv = nvverts(mesh);
  maxu = nuquads(mesh);
  maxv = nvquads(mesh);
  found = 0;
  for (u=0; u<maxu; ++u) {
    for (v=0; v<maxv; ++v) {
      poly->v[0]->pt = MESHPOINT(u,   v  );
      poly->v[1]->pt = MESHPOINT(u,   v+1);
      poly->v[2]->pt = MESHPOINT(u+1, v+1);
      poly->v[3]->pt = MESHPOINT(u+1, v  );
#if 0
fprintf(stderr, "mesh picking quad\n\
	%f  %f  %f\n\
	%f  %f  %f\n\
	%f  %f  %f\n\
	%f  %f  %f\n",
	poly->v[0]->pt.x,poly->v[0]->pt.y,poly->v[0]->pt.z,
	poly->v[1]->pt.x,poly->v[1]->pt.y,poly->v[1]->pt.z,
	poly->v[2]->pt.x,poly->v[2]->pt.y,poly->v[2]->pt.z,
	poly->v[3]->pt.x,poly->v[3]->pt.y,poly->v[3]->pt.z);
#endif
      found |= PolyPick(poly, pick, ap, T);
    }
  }
  if (found) return mesh;
  else return NULL;
}
