/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "meshP.h"
#include "mg.h"


Mesh *
MeshDraw(register Mesh *mesh)
{
  /* We pass mesh->flag verbatim to mgmesh() -- MESH_[UV]WRAP == MM_[UV]WRAP */

  if(!(mesh->flag & MESH_N)) {
    Appearance *ap;

    ap = mggetappearance();
    if(ap->shading != APF_CONSTANT || ap->flag & APF_NORMSCALE)
	MeshComputeNormals(mesh);
  }

  mgmesh(mesh->flag, mesh->nu, mesh->nv, mesh->p, mesh->n, mesh->c);
  return mesh;
}


