/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bboxP.h"
#include "meshP.h"

BBox *
MeshBound(mesh, T)
	Mesh	*mesh;
	Transform T;
{
	register int	n;
	register HPoint3	*p;
	HPoint3		min, max;
	HPoint3	*raw, *clean, p0, p1;
	register float	v;

	n = mesh->nu * mesh->nv;
	p = mesh->p;
	while(--n >= 0 && !finite(p->x + p->y + p->z))
		p++;
	if(n <= 0)
		return NULL;	/* No finite elements! */
	min = *p;
	if(T != NULL && T != TM_IDENTITY ) {
	    	HPt3Transform(T, &min, &min);
	    	if ( !(mesh->flag & MESH_4D) ) HPt3Normalize( &min, &min );
	    	}
	max = min;
	clean = &p1;
	while(--n >= 0) {
		p++;
            	if (T && T != TM_IDENTITY) 	{
			HPt3Transform(T, p, &p0);
			raw = &p0;
			}
		else raw = p;
		/* if ( !(mesh->flag & MESH_4D))   */
		    HPt3Normalize( raw , clean );
		if(min.x > clean->x) min.x = clean->x;
		else if(max.x < clean->x) max.x = clean->x;
		if(min.y > clean->y) min.y = clean->y;
		else if(max.y < clean->y) max.y = clean->y;
		if(min.z > clean->z) min.z = clean->z;
		else if(max.z < clean->z) max.z = clean->z;
/*
		if(min.w > clean->w) min.w = clean->w;
		else if(max.w < clean->w) max.w = clean->w;
*/
	    }
/*
	return (BBox *) GeomCreate("bbox", CR_FLAG, (mesh->flag & MESH_4D) ? BBOX_4D : 0, CR_MIN, &min, CR_MAX, &max, NULL);
*/
	return (BBox *) GeomCreate("bbox", CR_MIN, &min, CR_MAX, &max, NULL);
}

