/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "listP.h"

GeomClass *ListClass = NULL;

int ListPresent = 1;

static char listName[] = "list";

char *
ListName()
{
	return listName;
}

extern void ListHandleScan( List *, int (*func)(), void *arg );

GeomClass *
ListMethods()
{
    if( !ListClass ) {
        ListClass = GeomClassCreate(listName);
	
	ListClass->name = ListName;
        ListClass->methods = (GeomMethodsFunc *)ListMethods;
        ListClass->create = (GeomCreateFunc *)ListCreate;
	ListClass->get = (GeomGetFunc *)ListGet;
        ListClass->delete = (GeomDeleteFunc *)ListDelete;
        ListClass->bound = (GeomBoundFunc *)ListBound;
        ListClass->evert = (GeomEvertFunc *)ListEvert;
	ListClass->dice = (GeomDiceFunc *)ListDice;
        ListClass->transform = (GeomTransformFunc *)ListTransform;
	ListClass->pick = (GeomPickFunc *)ListPick;
        ListClass->draw = (GeomDrawFunc *)ListDraw;
	ListClass->replace = (GeomReplaceFunc *)ListReplace;
	ListClass->scan = (GeomScanFunc *)ListHandleScan;

	ListClass->import = (GeomImportFunc *)ListImport;
	ListClass->export = (GeomExportFunc *)ListExport;
    }

    return ListClass;
}
