/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <stdio.h>
#include "instP.h"
#include "streampool.h"
#include "transobj.h"
#include "handleP.h"

Geom *
InstImport( Pool *p )
{
    register Inst *inst = NULL;
    FILE *file;
    char *expect;

    if(p == NULL || (file = p->inf) == NULL)
	return 0;

    if(fexpecttoken(file, "INST"))
	return 0;

    for(;;) {
	switch(fnextc(file, 0)) {
	case EOF:
	case CKET:
	    goto done;

	case 'u':
	    if(fexpectstr(file, "unit"))
		goto syntax;
	    goto geom;

	case 'g':
	    if(fexpectstr(file, "geom"))
		goto syntax;

	  geom:
	    if(inst == NULL)
		inst = (Inst *)GeomCCreate(NULL, InstMethods(), NULL);
	    expect = "geometry";
	    if(!GeomStreamIn(p, &inst->geomhandle, &inst->geom))
		goto failed;
	    if(inst->geomhandle)
		HandleRegister(&inst->geomhandle, (Ref *)inst,
				&inst->geom, HandleUpdRef);
	    break;

	case 't':		/* tlist ... or transform ... */
	    if(inst == NULL)
		inst = (Inst *)GeomCCreate(NULL, InstMethods(), NULL);
	    fgetc(file);
	    switch(fgetc(file)) {
	    case 'l':
		if(fexpectstr(file, "ist"))		/* "tlist" */
		    goto syntax;
	     transforms:
		if(inst == NULL)
		    inst = (Inst *)GeomCCreate(NULL, InstMethods(), NULL);
		expect = "TLIST object";
		if(!GeomStreamIn(p, &inst->tlisthandle, &inst->tlist))
		    goto failed;
		if(inst->tlisthandle)
		    HandleRegister(&inst->tlisthandle, (Ref *)inst,
				&inst->tlist, HandleUpdRef);
		break;

	    case 'r':
		if(fexpectstr(file, "ansform"))		/* "transform" */
		    goto syntax;
		if(fexpectstr(file, "s") == 0)	/* transforms = tlist */
		    goto transforms;
		if(inst == NULL)
		    inst = (Inst *)GeomCCreate(NULL, InstMethods(), NULL);
		expect = "transform matrix";
		if(!TransStreamIn(p, &inst->axishandle, inst->axis))
		    goto failed;
		if(inst->axishandle)
		    HandleRegister(&inst->axishandle, (Ref *)inst,
				inst->axis, TransUpdate);
		break;

	    default:
		goto syntax;

	    }
	    break;

	default:
	syntax:
	  OOGLError(1, "InstStreamIn: bad INST syntax at: '%c' in %s",
			fnextc(file, 0), p->poolname);
	  goto bogus;

	failed:
	  OOGLError(1, "InstStreamIn: couldn't read %s in INST at: '%c' in %s",
			expect, fnextc(file,0), p->poolname);

        bogus:
	  GeomDelete((Geom *)inst);
	  return NULL;
	}
    }

  done:
    if(inst->geom && !inst->geomhandle)
	GeomDelete(inst->geom);	/* maintain ref count */
    if(inst->tlist && !inst->tlisthandle)
	GeomDelete(inst->tlist); /* ditto */
    return (Geom *)inst;
}

int
InstExport( Inst *inst, Pool *pool )
{
    int ok = 1;

    if(inst == NULL || pool == NULL || pool->outf == NULL)
	return NULL;

    fprintf(pool->outf, "INST\n");
    if(inst->tlist != NULL || inst->tlisthandle != NULL) {
	fprintf(pool->outf, "  tlist ");
	ok &= GeomStreamOut(pool, inst->tlisthandle, inst->tlist);
    } else {
	ok &= TransStreamOut(pool, inst->axishandle, inst->axis);
    }
    if(inst->geom != NULL || inst->geomhandle != NULL) {
	fprintf(pool->outf, "  geom ");
	ok &= GeomStreamOut(pool, inst->geomhandle, inst->geom);
    }
    return ok;
}
