/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "instP.h"
#include "tlistP.h"


Inst *
InstDice( Inst *inst, int nu, int nv )
{
    GeomDice(inst->geom, nu, nv);
    return inst;
}

Inst *
InstEvert( Inst *inst )
{
    GeomEvert( inst->geom );
    return inst;
}


InstHandleScan( Inst *inst, int (*func)(), void *arg )
{
    if(inst == NULL)
	return;

    if(inst->axishandle)
	(*func)(&inst->axishandle, inst, arg);
    if(inst->tlisthandle)
	(*func)(&inst->tlisthandle, inst, arg);
    if(inst->geomhandle)
	(*func)(&inst->geomhandle, inst, arg);

    if(inst->geom)
	GeomHandleScan(inst->geom, func, arg);
    if(inst->tlist)
	GeomHandleScan(inst->tlist, func, arg);
}


Inst *
InstPosition( inst, T )
    Inst *inst;
    Transform T;
{
    int i;
    GeomIter *it;

    it = GeomIterate((Geom *)inst, DEEP);
    if(NextTransform(it, T) > 0) {
	if(NextTransform(it, T) == 0)
	    return inst;
	DestroyIter(it);
	return NULL;	/* Error -- InstPosition on a multi-element inst */
    }
    return NULL;	/* Bizarre but possible -- no transforms at all */
}

/*
 * Force a single transform equal to T.
 * We discard any tlist/tlisthandle and just assign to axis.
 */
Inst *
InstTransformTo( inst, T )
    Inst *inst;
    Transform T;
{
    if(inst->tlist) {
	GeomDelete(inst->tlist);
	inst->tlist = NULL;
    }
    if(inst->tlisthandle) {
	HandlePDelete(&inst->tlisthandle);
	inst->tlisthandle = NULL;
    }
    TmCopy( T, inst->axis );
    return inst;
}

/*
 * Postmultiply inst by transform T.  Tricky:
 * - If this is a simple inst, just apply transform to axis.
 * - Otherwise, if leading node of tlist is an unshared, single-element TList,
 *	multiply our transform into its matrix.
 * - Failing that, insert a single-element TList as top of hierarchy.
 */
      
Inst *
InstTransform( inst, T )
    Inst *inst;
    Transform T;
{
    register Tlist *tl;

    if(inst->tlist == NULL && inst->tlisthandle == NULL) {
	TmConcat( inst->axis, T, inst->axis );
    } else {
	tl = (Tlist *)inst->tlist;
	if(tl != NULL && tl->class == TlistClass && tl->nelements == 1
			&& tl->ref_count == 1) {
	    TmConcat( tl->elements, T, tl->elements );
	} else {
	    inst->tlist = GeomCCreate(NULL, TlistMethods(),
			CR_TLIST, tl, CR_TLISTHANDLE, inst->tlisthandle, NULL);
	    inst->tlisthandle = NULL;
	}
    }
    return inst;
}
