/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "instP.h"
#include "pick.h"

GeomClass *InstClass = NULL;

int InstPresent = 1;

static char instName[] = "inst";


char *
InstName()
{
	return instName;
}

extern Geom *InstPick( Geom *, Pick *, Appearance *, Transform );
extern GeomScanFunc InstHandleScan;

GeomClass *
InstMethods()
{
    if( !InstClass ) {
	InstClass = GeomClassCreate(instName);
	
	InstClass->name = InstName;
        InstClass->methods = (GeomMethodsFunc *)InstMethods;
        InstClass->create = (GeomCreateFunc *)InstCreate;
	InstClass->delete = (GeomDeleteFunc *)InstDelete;
        InstClass->bound = (GeomBoundFunc *)InstBound;
        InstClass->evert = (GeomEvertFunc *)InstEvert;
	InstClass->dice = (GeomDiceFunc *)InstDice;
	InstClass->position = (GeomPositionFunc *)InstPosition;
	InstClass->transformto = (GeomTransformToFunc *)InstTransformTo;
        InstClass->transform = (GeomTransformFunc *)InstTransform;
	InstClass->pick = (GeomPickFunc *)InstPick;
        InstClass->draw = (GeomDrawFunc *)InstDraw;
	InstClass->replace = (GeomReplaceFunc *)InstReplace;
	InstClass->get = (GeomGetFunc *)InstGet;
	InstClass->scan = (GeomScanFunc *)InstHandleScan;

	InstClass->import = InstImport;
	InstClass->export = (GeomExportFunc *)InstExport;
    }

    return InstClass;
}
