/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * Compute bounding box of an Inst
 */
#include "instP.h"

BBox *
InstBound( inst, T )
    register Inst *inst;
    Transform T;
{
    register BBox *geombbox;
    Transform Tnew;
    GeomIter *it;

    if( inst == NULL || inst->geom == NULL)
	return NULL;

    it = GeomIterate( (Geom *)inst, DEEP );
    geombbox = NULL;
    while(NextTransform(it, Tnew) > 0) {
	register BBox *box;

	TmConcat( Tnew, T, Tnew );
	if((box = (BBox *)GeomBound( inst->geom, Tnew )) != NULL) {
	    if(geombbox) {
		BBoxUnion3(geombbox, box, geombbox);
		GeomDelete((Geom *)box);
	    } else
		geombbox = box;
	}
    }
    return geombbox;
}
