/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * $Header: /usr8/geom/devel/ngrap/src/lib/gprim/geom/RCS/knownclass.c,v 1.17 1992/04/11 16:50:34 slevy Exp $
 */

#include <string.h>

#include "geomclass.h"

/*
 * Here's we list all classes known to this object library.
 * Edit this if you add a new class for general use.
 * It's not mandatory to list a class here, but it helps -- generic
 * GeomLoad, GeomPrivate, GeomClassForAll routines benefit from this.
 *
 * Some may not really be linked in, but only ghosts from the stub library.
 * We tell ghosts from warm bodies by their "present" tag -- an int
 * which is 1 for real object routines, 0 for stubs.
 *
 * If you call GeomKnownClassInit(), better link either with all
 * object libraries or with the stub library!
 *
 */
extern int
	BBoxPresent,
	BezierListPresent,
	BezierPresent,
	InstPresent,
	LincolnPresent,
	ListPresent,
	MeshPresent,
	PolyListPresent,
	QuadPresent,
	TlistPresent,
	VectPresent;

extern GeomClass *
	BBoxMethods(),
	BezierListMethods(),
	BezierMethods(),
	InstMethods(),
	LincolnMethods(),
	ListMethods(),
	MeshMethods(),
	PolyListMethods(),
	QuadMethods(),
	TlistMethods(),
	VectMethods();

static struct knownclass {
	int *presenttag;
	GeomClass *(*methods)();
	char *loadsuffix;
} known[] = {

#if defined(__STDC__) || defined(__ANSI_CPP__)

#define KNOWN(name, suffix) \
	{ &name##Present, (GeomClass *(*)())name##Methods,  suffix }

#else /* non-ANSI */

#define	KNOWN(name, suffix) \
	{ &name/**/Present,  (GeomClass *(*)())name/**/Methods,  suffix }
#endif

	KNOWN(Bezier,	NULL),
	KNOWN(BezierList,	"bez"),
	KNOWN(BezierList,	"bbp"),
	KNOWN(PolyList,	"off"),
	KNOWN(Tlist,	"tl"),
	KNOWN(Tlist,	"grp"),
	KNOWN(Tlist,	"prj"),
	KNOWN(BBox,	NULL),
	KNOWN(Inst,	NULL),
	KNOWN(List,	"list"),
	KNOWN(Quad,	"quad"),
	KNOWN(Mesh,	"mesh"),
	KNOWN(Vect,	"vect"),
	KNOWN(Lincoln,	"iL"),
	NULL
};

void
GeomKnownClassInit()
{
	register struct knownclass *k;
	static char done = 0;

	if(!done) {
	    done = 1;
	    for(k = known; k->presenttag != NULL; k++)
		if(*k->presenttag)
		    (void) (*k->methods)();
	}
}

/*
 * This should really be in per-class attributes, not this
 * centralized table, but there's no mechanism for that yet.
 */
GeomClass *
GeomFName2Class(str)
	char *str;
{
	register char *p;
	register struct knownclass *k;

	if(str == NULL || (p = strrchr(str, '.')) == NULL)
		return NULL;
	p++;
	for(k = known; k->presenttag != NULL; k++)
		if(*k->presenttag && k->loadsuffix != NULL &&
		   strcmp(p, k->loadsuffix) == 0)
			return((*k->methods)());
	return NULL;
}
