/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "string.h"
#include "geomclass.h"

static struct classtable {
    struct classtable *next;
    char *classname;
    GeomClass *class;
} *table = NULL;

GeomClass *
GeomClassLookup( name )
    char *name;
{
    static char done = 0;
    register struct classtable *cp;

    if(!done) {
	done = 1;
	GeomKnownClassInit();
    }
    for(cp = table; cp != NULL; cp = cp->next)
	if( strcmp( cp->classname, name ) == 0 )
	    return cp->class;
    return NULL;
}

static
GeomClassInstall( name, class )
    char *name;
    GeomClass *class;
{
    register struct classtable *cp;

    cp = (struct classtable *)malloc(sizeof(struct classtable));
    cp->next = table;
    table = cp;
    cp->classname = strdup(name);
    cp->class = class;
}

GeomClass *
GeomSubClassCreate( classname, subclassname )
    char *classname, *subclassname;
{
    GeomClass *class, *subclass;

    class = GeomClassLookup( classname );
    if( !class ) {
	class = GeomNew(GeomClass);
	bzero( (char *)class, sizeof(GeomClass) );
	GeomClassInstall( classname, class );
    }
    subclass = GeomNew(GeomClass);
    bcopy( (char *)class, (char *)subclass, sizeof(GeomClass) );
    subclass->super = class;
    GeomClassInstall( subclassname, subclass );

    return subclass;
}

GeomClass *
GeomClassCreate( name )
    char *name;
{
    return GeomSubClassCreate( "geom", name );
}

GeomClass *
GeomMethods( object )
Geom *object;
{
    return object ? object->class : NULL;
}

/*
 * Call a function for all known classes.
 */
void *
GeomClassIterate( )
{
    return (void *)table;
}

GeomClass *
GeomNextClass( it )
    register void *it;
{
    GeomClass *c;
#define  iter  ((struct classtable **)it)

    if(*iter == NULL)
	return NULL;
    c = (*iter)->class;
    *iter = (*iter)->next;
    return c;

#undef iter
}
