/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "geomclass.h"

/*
 * Compute the bounding box of a geom.
 * If a transform T is supplied, compute bbox of geom transformed by T;
 * if T is NULL, compute bbox of geom in its native coordinates.
 */

Geom *
GeomBound(geom, T)
    Geom *geom;
    Transform T;
{
    if (geom && geom->class->bound) {
	return (*geom->class->bound) (geom, T==NULL ? TM_IDENTITY : T);
    }
    return NULL;
}
