/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;

This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <ctype.h>
#include "bezierP.h"

/* a hack: introduce new names of the form BEZUVM and BEZUVM_ST, where
	U	is u-degree of the polynomial and
	V	is v-degree of the polynomial and
	M	is the dimension of the points involved
*/

static int
bezierheader( file, bezier )
    register FILE *file;
    register Bezier *bezier;
{
    int binary = 0;

		/* Parse {BBP|STBBP|BEZuvn[_ST]} [BINARY] */

    bezier->flag = BEZ_P | BEZ_REMESH;
    bezier->dimn = 3;
    bezier->degree_u = bezier->degree_v = 3;	/* Default bicubic 3-D patch */

    bezier->nu = bezier->nv = 0;

    switch(fnextc(file, 0)) {
    case 'S':
	if(fexpectstr(file, "STBBP"))
	    return -1;
	bezier->flag |= BEZ_ST;			/* STBBP */
	break;

    case 'C':
	bezier->flag |= BEZ_C;
	(void) getc(file);			/* Assume 'B' follows */
    case 'B':
	(void) getc(file);
	if(fexpectstr(file, "BP") == 0)		/* BBP */
	    break;
	if(fexpectstr(file, "EZ") != 0)		/* BEZuvn */
	    return -1;
	bezier->degree_u = fgetc(file) - '0';	/* Get order and dimension */
	bezier->degree_v = fgetc(file) - '0';	/* as three 1-digit numbers */
	bezier->dimn = fgetc(file) - '0';

	if(fexpectstr(file, "_ST") == 0)	/* Optional _ST suffix */
	    bezier->flag |= BEZ_ST;

	if(bezier->degree_u <= 0 || bezier->degree_u > MAX_BEZ_DEGREE ||
	   bezier->degree_v <= 0 || bezier->degree_v > MAX_BEZ_DEGREE ||
	   bezier->dimn < 3 || bezier->dimn > MAX_BEZ_DIMN)
	    return -1;
	break;

    default:
	return -1;
    }

    if(fnextc(file, 1) == 'B') {
	if(fexpectstr(file, "BINARY"))
	    return -1;
	binary = 1;
	if(fnextc(file, 1) == '\n')
	    (void) fgetc(file);		/* Toss \n */
    }

    bezier->CtrlPnts = NULL;
    bezier->STCords = NULL;
    bezier->mesh = NULL;
    return(binary);
}


List *
BezierListFLoad( file, fname )
    FILE *file;
    char *fname;
{
    Geom 	*bezierlist;
    Bezier 	proto, bez;
    GeomClass	*bezclass = BezierMethods();
    GeomClass	*bezlistclass = BezierListMethods();
    int		totalfloats;
    int		nf, ok;
    int		binary;
    Geom	*geom;

    binary = bezierheader( file, &proto );
    if(binary < 0)
	return NULL;

    /* begin a list with empty list */
    bezierlist = NULL;

    totalfloats = (proto.degree_u+1)*(proto.degree_v+1)*proto.dimn;
    for(;;) {
	/* get new space */
	ok = 0;
	bez = proto;		/* should be a call to GeomCopy */
				/* copy over header info */

	if((bez.CtrlPnts = OOGLNewN(float,totalfloats)) == NULL)
	    break;

	nf = fgetnf(file, totalfloats, bez.CtrlPnts, binary);
	if(nf < totalfloats) {
	    ok = (nf == 0);
	    break;
	}

	if (bez.flag & BEZ_ST) {
	    if((bez.STCords = OOGLNewN(float,8)) == NULL)
		break;
	    if(fgetnf(file, 8, bez.STCords, binary) != 8)
		break;
	}
	if (bez.flag & BEZ_C) {
	    /* Load 4 colors, for the 4 corners of the patch, v-major order. */
	    if(fgetnf(file, 16, (float *)bez.c, binary) != 16)
		break;
	}

	/* successful read; append to list */
	geom = GeomCCreate (NULL,BezierMethods(),  CR_NOCOPY,
		  CR_FLAG, bez.flag | BEZ_REMESH,
		  CR_DEGU, bez.degree_u, CR_DEGV, bez.degree_v,
		  CR_DIM, bez.dimn, CR_POINT, bez.CtrlPnts,
		  CR_COLOR, bez.c, CR_END);
	if(bezierlist)
	    ListAppend(bezierlist, geom);
	else
	    bezierlist = GeomCCreate(NULL, BezierListMethods(),
					CR_GEOM, geom, CR_END);
    }

    if(!ok) {
	OOGLError(1, "BezierListFLoad: syntax error in %s", fname);
	GeomDelete(bezierlist);	/* Scrap everything on error */
	return NULL;
    }

    return (List *)bezierlist;
}

List *
BezierListLoad( name )
char *name;
{
    FILE *file;
    List *bezierlist;

    file = fopen( name, "r" );
    if( file == NULL ) {
	OOGLError(1, "BezierLoad: can't open %s: %s", name, sperror());
	return NULL;
    }
    bezierlist = BezierListFLoad( file, name );
    fclose(file);

    return bezierlist;
}
