/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef BEZIERDEFS
#define BEZIERDEFS

#include "mesh.h"
#include "list.h"

#define BEZIERMAGIC	GeomMagic ('b', 1)
#define BEZ_P 		00
#define BEZ_ST 		01
#define	BEZ_C		02
#define BEZ_PST 	(BEZ_P | BEZ_ST)
#define BEZ_BINARY 	0x4
#define BEZ_REMESH 	0x8		/* need to recompute mesh */
#define BEZ_4D		0x10
#define MAX_BEZ_DEGREE	6
#define MAX_BEZ_DIMN	4
#define BEZ_DEFAULT_MESH_SIZE	10

typedef struct Bezier Bezier;

GeomClass	*BezierMethods(), *BezierListMethods();
Mesh 		*BezierReDice( Bezier * );
Bezier		*BezierDice( Bezier *, int nu, int nv );
char           	*BezierListName();
List 		*BezierListLoad();
List		*BezierListFLoad();
List 		*BezierListSave();
List		*BezierListFSave();
char           	*BezierName();
BBox           	*BezierBound();
Bezier      	*BezierEvert();
Bezier      	*BezierDraw( Bezier *bezier );
Geom      	*BezierPick( Bezier *, Pick *, Appearance *, Transform );
Bezier      	*BezierTransform();

int		 BezierExport();
int		 BezierUnexport();
Bezier		*BezierImport();

#endif /* ! BEZIERDEFS */
