/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bezierP.h"

static GeomClass *aBezierMethods = NULL;
static GeomClass *aBezierListMethods = NULL;

int BezierPresent = 1;
int BezierListPresent = 1;

static char nameBezier[] = "bezier";
static char nameBezierList[] = "bezierlist";

char *
BezierName()
{
	return nameBezier;
}

char *
BezierListName()
{
	return nameBezierList;
}


GeomClass *
BezierMethods()
{
    if( !aBezierMethods ) {
	aBezierMethods = GeomClassCreate(nameBezier);

	aBezierMethods->name = BezierName;
        aBezierMethods->methods = (GeomMethodsFunc *)BezierMethods;
        aBezierMethods->create = (GeomCreateFunc *)BezierCreate;
        aBezierMethods->evert = (GeomEvertFunc *)BezierEvert;
	aBezierMethods->delete = (GeomDeleteFunc *)BezierDelete;
        aBezierMethods->bound = (GeomBoundFunc *)BezierBound;
        aBezierMethods->draw = (GeomDrawFunc *)BezierDraw;
        aBezierMethods->pick = (GeomDrawFunc *)BezierPick;
	aBezierMethods->dice = (GeomDiceFunc *)BezierDice;
    }
    return aBezierMethods;
}

GeomClass *
BezierListMethods()
{
    if( !aBezierListMethods ) {
	(void) ListMethods();
	aBezierListMethods = GeomSubClassCreate("list", "bezierlist");

	aBezierListMethods->name = BezierListName;
        aBezierListMethods->methods = (GeomMethodsFunc *)BezierListMethods;
        aBezierListMethods->fload = (GeomFLoadFunc *)BezierListFLoad;
	aBezierListMethods->fsave = (GeomFSaveFunc *)BezierListFSave;
	aBezierListMethods->import = NULL;
	aBezierListMethods->export = NULL;
    }
    return aBezierListMethods;
}
