/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bboxP.h"

BBox *
BBoxFLoad(FILE *f, char *fname)
{
    BBox b;
    BBox *bbox;

    switch(fnextc(f, 0)) {
    case '4': fgetc(f);  /* and fall into ... */
    case 'B': if(fexpectstr(f, "BBOX") == 0)
		break;
    default:
	return NULL;
    }

    if(fgetnf(f, 4, &b.min.x, 0) != 4 ||
			fgetnf(f, 4, &b.max.x, 0) != 4) {
	OOGLError(1, "BBoxFLoad: exepcted 8 floats at '%c'", fnextc(f, 0));
	return NULL;
    }

    bbox = OOGLNewE(BBox, "BBoxFLoad BBox");
    *bbox = b;

    GGeomInit(bbox, BBoxMethods(), BBOXMAGIC, NULL);
    return bbox;
}
