/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */
static char *copyright = "Copyright (C) 1992 The Geometry Center";

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bboxP.h"
#include "appearance.h"

/*--------------------------------------------------------------------------
 * Function:	BBoxCreate
 * Description: creates or edits a bounding box
 * Args:	BBox *exist: existing bbox to be edited, if using editing.
 *				NULL otherwise.
 *		GeomClass *classp: 
 *		a_list: List of option type - option pairs.  Option types
 *			are specified by integers, with 0 signifying end of
 *			list.
 * Returns:	Pointer to BBox created or edited.
 */

BBox *
BBoxCreate (exist, classp, a_list)
BBox *exist;
GeomClass *classp;
va_list a_list;
{
    register BBox *bbox;
    int attr, copy = 1, fourd = 0;
    HPoint3 *min, *max;

    min = NULL;  max = NULL;

    if (exist == NULL) {
	bbox = OOGLNewE(BBox, "BBoxCreate BBox");
	bbox->flag = BBOX_P;
    } else {
	/* Check that exist is in fact a BBox. */
	bbox = exist;
    }

    while (attr = va_arg (a_list, int)) switch (attr) {
	case CR_FLAG:
	    bbox->flag = va_arg (a_list, int );
	    break;
	case CR_MIN:
	    min = va_arg (a_list, HPoint3 *);
	    bbox->min = *min;
	    break;
	case CR_MAX:
	    max = va_arg (a_list, HPoint3 *);
	    bbox->max = *max;
	    break;
	default:
	    if (GeomDecorate (bbox, &copy, attr, &a_list)) {
		OOGLError (0, "BBoxCreate: Undefined attribute: %d", attr);
		OOGLFree (bbox);
		return NULL;
	    }
    }

    if (exist != NULL) return exist;
    
    /* If min or max not set, fail. */
    if ((min == NULL) || (max == NULL)) {
	OOGLError (0, "BBoxCreate: min or max not explicitly defined.");
	OOGLFree (bbox);
	return NULL;
    }

    GGeomInit (bbox, classp, BBOXMAGIC, NULL);
    return (bbox);
}
