/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform.h"
#include "transobj.h"
#include "handleP.h"

/* 
 * Operations on TransObj objects.
 */

void
TransPosition(TransObj *tobj, Transform T)	/* Get transform into T */
{ TmCopy(tobj->T, T); }

void
TransTransformTo(TransObj *tobj, Transform T)	/* Set transform from T */
{ TmCopy(T, tobj->T); }

void
TransDelete(TransObj *tobj)
{
    if(tobj != NULL && RefDecr((Ref *)tobj) <= 0)
	OOGLFree(tobj);
}


/*
 * Communications
 */

HandleOps TransOps = {
	"trans",
	TransStreamIn,
	TransStreamOut,
	TransDelete,
	NULL,
	NULL
};

void
TransUpdate( Handle **hp, Ref *ignored, Transform Tfixme )
{
    register Handle *h = *hp;

    if(h != NULL && h->object != NULL)
	TmCopy( ((TransObj *)(h->object))->T, Tfixme );
}

TransStreamIn( Pool *p, Handle **hp, Transform T )
{
    Handle *h = NULL;
    Handle *hname = NULL;
    register TransObj *tobj = NULL;
    char *w;
    int c;
    int more = 0;
    int brack = 0;

    if(p == NULL || p->inf == NULL)
	return 0;


    do {
	more = 0;
	switch(c = fnextc(p->inf, 0)) {
	case '{': brack++; fgetc(p->inf); break;
	case '}': if(brack--) fgetc(p->inf); break;
	case 't':
	    if(fexpectstr(p->inf, "transform"))
		return 0;
	    more = 1;
	    break;

	case 'd':
	    if(fexpectstr(p->inf, "define"))
		return 0;
	    hname = HandleAssign(ftoken(p->inf, 0), &TransOps, NULL);
	    break;

	case '<':
	case ':':
	case '@':
	    fgetc(p->inf);
	    w = fdelimtok("{}()", p->inf, 0);
	    if(h) {
		OOGLError(1, "Can't rename [%s] named Transform [%s] (in %s)",
			h->name, w, p->poolname);
		return 0;
	    }
	    if(c == '<' && HandleByName(w, &TransOps) == NULL)
		w = findfile(p->poolname, 0);
	    h = HandleReferringTo(c, w, &TransOps, NULL);
	    if(h)
		tobj = (TransObj *)h->object;
	    break;

	default:
	    /*
	     * Anything else should be a 4x4 matrix
	     */
	    if(tobj == NULL) {
		tobj = OOGLNewE(TransObj, "TransStreamIn TransObj");
		RefInit((Ref *)tobj, TRANSMAGIC);
	    }
	    if(fgettransform(p->inf, 1, &tobj->T[0][0], 0) <= 0)
		return 0;
	}
    } while(brack || more);

    if(hname != NULL) {
	if(tobj)
	    HandleSetObject(hname, (Ref *)tobj);
	h = hname;
    }

    if(h == NULL && tobj != NULL && p->ops == &TransOps)
	h = HandleAssign(p->poolname, &TransOps, (Ref *)tobj);


    if(h != NULL && tobj != NULL)
	HandleSetObject(h, (Ref *)tobj);

    if(tobj != NULL && T != TMNULL)
	TmCopy(tobj->T, T);

    if(h != NULL && hp != NULL) {
	if(*hp != h) {
	    if(*hp != NULL)
		HandlePDelete(hp);
	    *hp = h;
	}
    } else {
	TransDelete(tobj);	/* Maintain ref count */
    }

    return (h != NULL || tobj != NULL);
}

int
TransStreamOut( Pool *p, Handle *h, Transform T )
{
    int putdata;

    if(p->outf == NULL)
	return 0;

    fprintf(p->outf, "transform {\n");

    putdata = PoolStreamOutHandle( p, h, T != TMNULL );
    if(putdata)
	fputtransform(p->outf, 1, &T[0][0], 0);
    fputs("}\n", p->outf);
}
