/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <math.h>
#include "radians.h"
#include "transform3.h"

HPoint3 TM3_XAXIS = { 1.0, 0.0, 0.0, 0.0 };
HPoint3 TM3_YAXIS = { 0.0, 1.0, 0.0, 0.0 };
HPoint3 TM3_ZAXIS = { 0.0, 0.0, 1.0, 0.0 };

void
Tm3RotateX( T, angle )
    Transform3 T;
    float angle;
{
    Tm3Identity( T );
    Ctm3RotateX( T, angle );
}

void
Tm3RotateY( T, angle )
    Transform3 T;
    float angle;
{
    Tm3Identity( T );
    Ctm3RotateY( T, angle );
}

void
Tm3RotateZ( T, angle )
    Transform3 T;
    float angle;
{
    Tm3Identity( T );
    Ctm3RotateZ( T, angle );
}

/*
 * Post-multiply the matrix by a rotation about an axis.
 */
void
Tm3Rotate( T, angle, axis)
    Transform3 T;
    float angle;
    HPoint3 *axis;
{
    HPoint3 Vu;
    float sinA, cosA, versA;
	
    if(      axis == (HPoint3 *)&TM3_XAXIS ) Tm3RotateX( T, angle );
    else if( axis == (HPoint3 *)&TM3_YAXIS ) Tm3RotateY( T, angle );
    else if( axis == (HPoint3 *)&TM3_ZAXIS ) Tm3RotateZ( T, angle );
    else {
	Pt3Copy( axis, &Vu );
	Pt3Unit( &Vu );

	sinA = sin(angle); 
	cosA = cos(angle); 
	versA = 1 - cosA;

	Tm3Identity( T );
	T[X][X] = Vu.x*Vu.x*versA + cosA;
	T[Y][X] = Vu.x*Vu.y*versA - Vu.z*sinA;
	T[Z][X] = Vu.x*Vu.z*versA + Vu.y*sinA;

	T[X][Y] = Vu.y*Vu.x*versA + Vu.z*sinA;
	T[Y][Y] = Vu.y*Vu.y*versA + cosA;
	T[Z][Y] = Vu.y*Vu.z*versA - Vu.x*sinA;

	T[X][Z] = Vu.x*Vu.z*versA - Vu.y*sinA;
	T[Y][Z] = Vu.y*Vu.z*versA + Vu.x*sinA;
	T[Z][Z] = Vu.z*Vu.z*versA + cosA;
    }
}
