/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <stdio.h>
#include <math.h>
#include "transform3.h"
#include "ooglutil.h"	/* For OOGLError */

/*
 *     (  2*n/(r-l)      0             0          0 )
 *     (     0        2*n/(t-b)        0          0 )
 * T = ( (r+l)/(r-l) (t+b)/(t-b)  (f+n)/(f-n)    -1 )
 *     (     0		 0	 -2*f*n/(f-n)     0 )
 *
 * Transform a row vector {xw,yw,zw,w} * T => {X,Y,Z,-z}
 * mapping the given viewing frustum into the cube -1 <= {X,Y,Z} <= 1,
 * with Z = -1 at near plane (z = -n), +1 at far plane (z = -f)
 * since the camera is looking in its -Z direction.
 * Here l and r are the x coordinates, and b and t the y coordinates,
 * of the edges of the viewing frustum at the near plane, z = -n.
 *
 * Note that n and f should be the positive distances to the near & far planes,
 * not the negative Z coordinates of those planes.
 */
void
Tm3Perspective( T, l, r, b, t, n, f )
    Transform3 T;
    float l,r,b,t,n,f;
{
    Tm3Identity( T );

    if( l == r ) {
	OOGLError(1/*UserError*/, "Tm3Perspective: l and r must be different." );
	return;
    }
    if( b == t ) {
	OOGLError(1/*UserError*/, "Tm3Perspective: b and t must be different." );
	return;
    }
    if( n == f ) {
	OOGLError(1/*UserError*/, "Tm3Perspective: n and f must be different." );
	return;
    }

    T[X][X] = 2*n/(r-l);
    T[Y][Y] = 2*n/(t-b);
    T[Z][Z] = -(f+n)/(f-n);
    T[W][W] = 0.;
    T[Z][W] = -1;
    T[Z][X] = (r+l)/(r-l);
    T[Z][Y] = (t+b)/(t-b);
    T[W][Z] = 2*n*f/(n-f);
}
