/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <stdio.h>
#include "transform3.h"

/*
 *     (     2/(r-l)          0             0        0 )
 *     (        0          2/(t-b)          0        0 )
 * T = (        0             0         -2/(f-n)     0 )
 *     (  -(r+l)/(r-l)  -(t+b)/(t-b)  -(f+n)/(f-n)   1 )
 *
 * Transform to the unit cube! Also flips from rh to lh. 
 */
void
Tm3Orthographic( T, l, r, b, t, n, f )
    Transform3 T;
    float l,r,b,t,n,f;
{
    Tm3Identity( T );

    if( l == r ) {
	fprintf( stderr, "Tm3Orthographic: l and r must be different.\n" );
	return;
    }
    if( b == t ) {
	fprintf( stderr, "Tm3Orthographic: b and t must be different.\n" );
	return;
    }
    if( n == f ) {
	fprintf( stderr, "Tm3Orthographic: n and f must be different.\n" );
	return;
    }

    T[X][X] =  2/(r-l);
    T[Y][Y] =  2/(t-b);
    T[Z][Z] = -2/(f-n);
    T[W][X] = -(r+l)/(r-l);
    T[W][Y] = -(t+b)/(t-b);
    T[W][Z] = -(f+n)/(f-n);
}
